/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import crystalpalace.coff.COFFObject;
import crystalpalace.coff.COFFParser;
import crystalpalace.export.ExportObject;
import crystalpalace.spec.LinkSpec;
import crystalpalace.spec.SpecLogger;
import crystalpalace.spec.SpecMessage;
import crystalpalace.spec.SpecObject;
import crystalpalace.spec.SpecPack;
import crystalpalace.spec.SpecParseException;
import crystalpalace.spec.SpecProgramException;
import crystalpalace.spec.SpecVars;
import crystalpalace.spec.TagStore;
import crystalpalace.util.CommandParser;
import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Packer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SpecProgram {
    protected Map directives = new HashMap();
    protected Stack state = new Stack();
    protected String parent = ".";
    protected String name = "";
    protected String last = "";
    protected Map cmdvars = null;
    protected SpecObject larg = null;
    protected String ltarg = null;
    protected String ltarch = null;
    protected TagStore tags = new TagStore();
    protected Map locals = new HashMap();
    protected List loggers = new LinkedList();

    public void addLogger(SpecLogger logger) {
        this.loggers.add(logger);
    }

    public void removeLogger(SpecLogger logger) {
        this.loggers.remove(logger);
    }

    public void logSpecMessage(SpecMessage message) {
        Iterator i = this.loggers.iterator();
        while (i.hasNext()) {
            ((SpecLogger)i.next()).logSpecMessage(message);
        }
    }

    public void reset() {
        this.state = new Stack();
        this.last = "";
        this.larg = null;
        this.ltarg = null;
    }

    public TagStore getTags() {
        return this.tags;
    }

    public SpecProgram(String parent) {
        this.parent = parent;
        this.name = new File(parent).getName();
    }

    public String getFile() {
        return this.parent;
    }

    public String getLastTarget() {
        return this.ltarg;
    }

    public SpecObject getLastArgument() {
        return this.larg;
    }

    public String getLastCommand() {
        return this.last;
    }

    public Stack getStack() {
        return this.state;
    }

    public boolean targets(String arch) {
        return this.getInstructionsForLabel(arch).size() > 0;
    }

    public List getInstructionsForLabel(String label) {
        if (!this.directives.containsKey(label)) {
            this.directives.put(label, new LinkedList());
        }
        return (LinkedList)this.directives.get(label);
    }

    protected void push(byte[] b, String source) {
        this.state.push(new SpecObject(this, b, source));
        this.larg = null;
    }

    protected void push(ExportObject o, String source) {
        this.state.push(new SpecObject(this, o, source));
        this.larg = null;
    }

    protected void push(SpecObject obj) {
        this.state.push(obj);
        this.larg = null;
    }

    public Map getLastVars() {
        if (this.cmdvars == null) {
            return new HashMap();
        }
        return this.cmdvars;
    }

    protected SpecObject pop() throws SpecProgramException {
        if (this.state.empty()) {
            throw new SpecProgramException(this, "POP - stack is empty");
        }
        this.larg = (SpecObject)this.state.pop();
        return this.larg;
    }

    public String getCallTarget(String name, String label, String arch) throws SpecProgramException {
        if ("".equals(name)) {
            if (this.targets(label)) {
                return label;
            }
            if (this.targets(arch)) {
                return arch;
            }
            throw new SpecProgramException(this, "Spec does not have target for '" + label + "' or '" + arch + "'");
        }
        if (this.targets(name + "." + label)) {
            return name + "." + label;
        }
        if (this.targets(name + "." + arch)) {
            return name + "." + arch;
        }
        throw new SpecProgramException(this, "Spec does not have target for '" + name + "." + label + "' or '" + name + "." + arch + "'");
    }

    public void _run(String name, String label, String arch, Map env) throws SpecProgramException, SpecParseException {
        String calltarget = this.getCallTarget(name, label, arch);
        List inst = this.getInstructionsForLabel(calltarget);
        this.ltarg = calltarget;
        this.ltarch = arch;
        Iterator i = inst.iterator();
        while (i.hasNext()) {
            CommandParser command = (CommandParser)i.next();
            this.last = command.getOriginal();
            this._runCommand(i, label, arch, env, command);
        }
    }

    protected void _runCommand(Iterator i, String label, String arch, Map env, CommandParser command) throws SpecProgramException, SpecParseException {
        String[] args;
        Object temp;
        try {
            this.cmdvars = null;
            temp = command.getArguments(new SpecVars(env, this.locals));
            args = ((CommandParser.Arguments)temp).args;
            this.cmdvars = ((CommandParser.Arguments)temp).vars;
        }
        catch (RuntimeException rex) {
            throw new SpecProgramException(this, rex.getMessage());
        }
        if ("load".equals(command.getCommand()) && args.length == 1) {
            try {
                temp = this.getFileFromArg(args[0]);
                this.push(CrystalUtils.readFromFile(((File)temp).getPath()), ((File)temp).getName());
            }
            catch (IOException ioex) {
                throw new SpecProgramException(this, ioex.getMessage());
            }
        }
        if ("load".equals(command.getCommand()) && args.length == 2) {
            try {
                temp = this.getFileFromArg(args[1]);
                this.putEnv(env, args[0], CrystalUtils.readFromFile(((File)temp).getPath()));
            }
            catch (IOException ioex) {
                throw new SpecProgramException(this, ioex.getMessage());
            }
        }
        if ("mergelib".equals(command.getCommand())) {
            try {
                temp = this.getFileFromArg(args[0]);
                ZipFile zip = new ZipFile((File)temp);
                Enumeration<? extends ZipEntry> e = zip.entries();
                LinkedList<COFFObject> coffs = new LinkedList<COFFObject>();
                while (e.hasMoreElements()) {
                    ZipEntry entry = e.nextElement();
                    InputStream is = zip.getInputStream(entry);
                    byte[] data = CrystalUtils.readBytes(is, (int)entry.getSize());
                    this.push(data, entry.getName());
                    SpecObject arg = this.pop();
                    coffs.add(this.createCOFF(arg));
                }
                SpecObject obj = this.pop();
                obj.getObject().merge(coffs);
                this.push(obj);
            }
            catch (RuntimeException rtx) {
                throw new SpecProgramException(this, rtx.getMessage());
            }
            catch (IOException ioex) {
                throw new SpecProgramException(this, ioex.getMessage());
            }
        }
        if (command.getCommand().startsWith(".")) {
            Map oldlocals = this.locals;
            this.locals = new HashMap();
            String oldltarg = this.ltarg;
            for (int x = 0; x < args.length; ++x) {
                this.locals.put("%" + (x + 1), args[x]);
            }
            this._run(command.getCommand().substring(1), label, arch, env);
            this.ltarg = oldltarg;
            this.locals = oldlocals;
        } else {
            if ("run".equals(command.getCommand())) {
                try {
                    temp = this.getFileFromArg(args[0]);
                    LinkSpec spec = LinkSpec.Parse(((File)temp).getPath());
                    spec.program.state = this.state;
                    spec.program.tags = this.tags;
                    spec.program.loggers = this.loggers;
                    for (int x = 1; x < args.length; ++x) {
                        spec.program.locals.put("%" + x, args[x]);
                    }
                    spec.program._run("", label, arch, env);
                }
                catch (IOException ioex) {
                    throw new SpecProgramException(this, ioex.getMessage());
                }
            }
            if ("call".equals(command.getCommand())) {
                try {
                    temp = this.getFileFromArg(args[0]);
                    LinkSpec spec = LinkSpec.Parse(((File)temp).getPath());
                    spec.program.state = this.state;
                    spec.program.tags = this.tags;
                    spec.program.loggers = this.loggers;
                    for (int x = 2; x < args.length; ++x) {
                        spec.program.locals.put("%" + (x - 1), args[x]);
                    }
                    spec.program._run(args[1], label, arch, env);
                }
                catch (IOException ioex) {
                    throw new SpecProgramException(this, ioex.getMessage());
                }
            }
            if ("setg".equals(command.getCommand())) {
                env.put(args[0], args[1]);
            } else if ("set".equals(command.getCommand())) {
                this.locals.put(args[0], args[1]);
            } else {
                byte[] value;
                SpecObject obj;
                String var;
                if ("pack".equals(command.getCommand())) {
                    var = args[0];
                    String template = args[1];
                    try {
                        SpecPack pack = new SpecPack(this, template);
                        this.putEnv(env, var, pack.apply(args, 2, env));
                    }
                    catch (NumberFormatException nex) {
                        throw new SpecProgramException(this, nex.getClass().getSimpleName() + " " + nex.getMessage());
                    }
                    catch (RuntimeException rex) {
                        throw new SpecProgramException(this, rex.getMessage());
                    }
                }
                if ("resolve".equals(command.getCommand())) {
                    String val = new SpecVars(env, this.locals).resolve(args[0]);
                    LinkedList<String> vals = new LinkedList<String>();
                    for (String partial : CrystalUtils.toList(val)) {
                        File temp2 = this.getFileFromArg(partial);
                        try {
                            vals.add(temp2.getCanonicalPath());
                        }
                        catch (IOException ioex) {
                            throw new SpecProgramException(this, ioex.getMessage() + ": " + temp2.getPath());
                        }
                    }
                    if (this.locals.containsKey(args[0])) {
                        this.locals.put(args[0], String.join((CharSequence)", ", vals));
                    } else if (env.containsKey(args[0])) {
                        env.put(args[0], String.join((CharSequence)", ", vals));
                    }
                } else if ("coffparse".equals(command.getCommand())) {
                    obj = this.pop();
                    try {
                        File temp3 = this.getOutFileFromArg(args[0]);
                        obj.getObject().coffparse(temp3);
                    }
                    catch (Exception ioex) {
                        throw new SpecProgramException(this, ioex.getMessage());
                    }
                    this.push(obj);
                } else if ("disassemble".equals(command.getCommand())) {
                    obj = this.pop();
                    try {
                        File temp4 = this.getOutFileFromArg(args[0]);
                        obj.getObject().disassemble(temp4);
                    }
                    catch (Exception ioex) {
                        throw new SpecProgramException(this, ioex.getMessage());
                    }
                    this.push(obj);
                } else if ("link".equals(command.getCommand())) {
                    value = this.pop().getBytes();
                    SpecObject obj2 = this.pop();
                    try {
                        obj2.getObject().link(args[0], value);
                    }
                    catch (RuntimeException rex) {
                        this.handleException(rex);
                    }
                    this.push(obj2);
                } else if ("linkfunc".equals(command.getCommand())) {
                    value = this.pop().getBytes();
                    SpecObject obj3 = this.pop();
                    try {
                        obj3.getObject().linkFunction(args[0], value);
                    }
                    catch (RuntimeException rex) {
                        this.handleException(rex);
                    }
                    this.push(obj3);
                } else if ("export".equals(command.getCommand())) {
                    obj = this.pop();
                    ExportObject eobj = obj.getObject();
                    try {
                        this.push(eobj.export(), obj.getSource());
                    }
                    catch (RuntimeException rex) {
                        this.handleException(rex);
                    }
                } else if ("make".equals(command.getCommand())) {
                    if (!"x64".equals(arch) && "make pic64".equals(command.getFullCommand())) {
                        throw new SpecProgramException(this, "make pic64 is x64-only");
                    }
                    obj = this.pop();
                    try {
                        ExportObject exp = new ExportObject(this, this.createCOFF(obj), args[0], command.getOptions());
                        this.push(exp, obj.getSource());
                    }
                    catch (RuntimeException rex) {
                        this.handleException(rex);
                    }
                } else if ("merge".equals(command.getCommand())) {
                    try {
                        SpecObject arg = this.pop();
                        COFFObject coff = this.createCOFF(arg);
                        SpecObject obj4 = this.pop();
                        obj4.getObject().merge(coff);
                        this.push(obj4);
                    }
                    catch (RuntimeException rex) {
                        this.handleException(rex);
                    }
                } else {
                    CommandParser commandz;
                    if ("reladdr".equals(command.getCommand())) {
                        throw new SpecProgramException(this, "reladdr is removed. Use fixptrs to avoid the x86 address hacks");
                    }
                    if ("fixptrs".equals(command.getCommand())) {
                        obj = this.pop();
                        String symbol = args[0];
                        if (!"x86".equals(arch) || !obj.getObject().isPIC()) {
                            throw new SpecProgramException(this, "fixptrs [_symbol] is x86 PIC-only");
                        }
                        try {
                            obj.getObject().fixX86References(symbol);
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("fixbss".equals(command.getCommand())) {
                        obj = this.pop();
                        String symbol = args[0];
                        if (!obj.getObject().isPIC()) {
                            throw new SpecProgramException(this, "fixbss [symbol] is PIC-only");
                        }
                        try {
                            obj.getObject().fixBSSReferences(symbol);
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("dfr".equals(command.getCommand())) {
                        obj = this.pop();
                        String symbol = args[0];
                        if (!obj.getObject().isPIC()) {
                            throw new SpecProgramException(this, "dfr [symbol] [method] <modules> is PIC-only");
                        }
                        try {
                            if (args.length == 3) {
                                obj.getObject().getResolvers().addResolver(symbol, args[1], args[2]);
                            } else {
                                obj.getObject().getResolvers().setDefaultResolver(symbol, args[1]);
                            }
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("attach".equals(command.getCommand())) {
                        obj = this.pop();
                        try {
                            obj.getObject().getHooks().attach(args[0], args[1]);
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("redirect".equals(command.getCommand())) {
                        obj = this.pop();
                        try {
                            obj.getObject().getHooks().redirect(args[0], args[1]);
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("addhook".equals(command.getCommand())) {
                        obj = this.pop();
                        try {
                            if (args.length == 1) {
                                obj.getObject().getHooks().addResolveHook(args[0]);
                            } else {
                                obj.getObject().getHooks().addResolveHook(args[0], args[1]);
                            }
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("filterhooks".equals(command.getCommand())) {
                        obj = this.pop();
                        try {
                            obj.getObject().getHooks().filterResolveHooks(this.getFromEnv(env, args[0]));
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("preserve".equals(command.getCommand())) {
                        obj = this.pop();
                        try {
                            obj.getObject().getHooks().preserve(args[0], args[1]);
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("protect".equals(command.getCommand())) {
                        obj = this.pop();
                        try {
                            obj.getObject().getHooks().protect(args[0]);
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("optout".equals(command.getCommand())) {
                        obj = this.pop();
                        try {
                            obj.getObject().getHooks().optout(args[0], args[1]);
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("remap".equals(command.getCommand())) {
                        obj = this.pop();
                        try {
                            obj.getObject().remap(args[0], args[1]);
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("exportfunc".equals(command.getCommand())) {
                        obj = this.pop();
                        if (!obj.getObject().isPICO()) {
                            throw new SpecProgramException(this, "exportfunc is for PICOs only");
                        }
                        try {
                            obj.getObject().getExports().export(args[0], args[1]);
                        }
                        catch (RuntimeException rex) {
                            throw new SpecProgramException(this, rex.getMessage());
                        }
                        this.push(obj);
                    } else if ("generate".equals(command.getCommand())) {
                        var = args[0];
                        int len = CrystalUtils.parseInt(args[1], 0);
                        if (len < 0) {
                            throw new SpecProgramException(this, "Nice try, we can't generate a negative size byte array");
                        }
                        byte[] val = new byte[len];
                        try {
                            SecureRandom rng = SecureRandom.getInstanceStrong();
                            rng.nextBytes(val);
                        }
                        catch (Exception ex) {
                            throw new SpecProgramException(this, ex.getMessage());
                        }
                        this.putEnv(env, var, val);
                    } else if ("patch".equals(command.getCommand())) {
                        var = args[1];
                        String sym = args[0];
                        SpecObject obj5 = this.pop();
                        if ("x86".equals(arch) && obj5.getObject().isPIC() && !obj5.getObject().hasX86Retaddr()) {
                            throw new SpecProgramException(this, "x86 PIC requires fixptrs is set to use patch");
                        }
                        try {
                            obj5.getObject().patch(sym, this.getFromEnv(env, var));
                        }
                        catch (RuntimeException rex) {
                            this.handleException(rex);
                        }
                        this.push(obj5);
                    } else if ("import".equals(command.getCommand())) {
                        String funcs = args[0];
                        SpecObject obj6 = this.pop();
                        if ("object".equals(obj6.getObject().getType())) {
                            try {
                                obj6.getObject().setAPI(funcs);
                            }
                            catch (RuntimeException rex) {
                                this.handleException(rex);
                            }
                        } else {
                            throw new SpecProgramException(this, "Argument is not a PICO (COFF) - can't import functions to it");
                        }
                        this.push(obj6);
                    } else if ("xor".equals(command.getCommand())) {
                        obj = this.pop();
                        byte[] key = this.getFromEnv(env, args[0]);
                        byte[] val = obj.getBytes();
                        for (int x = 0; x < val.length; ++x) {
                            int n = x;
                            val[n] = (byte)(val[n] ^ key[x % key.length]);
                        }
                        this.push(val, obj.getSource());
                    } else if ("rc4".equals(command.getCommand())) {
                        obj = this.pop();
                        byte[] key = this.getFromEnv(env, args[0]);
                        byte[] val = obj.getBytes();
                        try {
                            val = CrystalUtils.rc4encrypt(key, val);
                        }
                        catch (Exception ex) {
                            throw new SpecProgramException(this, ex.getMessage());
                        }
                        this.push(val, obj.getSource());
                    } else if ("preplen".equals(command.getCommand())) {
                        obj = this.pop();
                        byte[] data = obj.getBytes();
                        Packer pack = new Packer();
                        pack.little();
                        pack.addData(data);
                        this.push(pack.getBytes(), obj.getSource());
                    } else if ("prepsum".equals(command.getCommand())) {
                        obj = this.pop();
                        byte[] data = obj.getBytes();
                        Packer pack = new Packer();
                        pack.little();
                        pack.addDataVerify(data);
                        this.push(pack.getBytes(), obj.getSource());
                    } else if ("push".equals(command.getCommand())) {
                        this.push(this.getFromEnv(env, args[0]), args[0]);
                    } else if ("echo".equals(command.getCommand())) {
                        LinkedList<String> stuff = new LinkedList<String>();
                        for (int x = 0; x < args.length; ++x) {
                            stuff.add(args[x]);
                        }
                        this.logSpecMessage(SpecMessage.Echo(this, String.join((CharSequence)" ", stuff)));
                    } else if ("foreach".equals(command.getCommand())) {
                        commandz = (CommandParser)i.next();
                        if (CrystalUtils.toSet("foreach, next").contains(commandz.getCommand())) {
                            throw new SpecProgramException(this, "Nested foreach/next is not allowed");
                        }
                        Iterator j = CrystalUtils.toList(args[0]).iterator();
                        while (j.hasNext()) {
                            this.locals.put("%_", (String)j.next());
                            this._runCommand(i, label, arch, env, commandz);
                        }
                        this.locals.remove("%_");
                    } else if ("next".equals(command.getCommand())) {
                        commandz = (CommandParser)i.next();
                        if (CrystalUtils.toSet("foreach, next").contains(commandz.getCommand())) {
                            throw new SpecProgramException(this, "Nested foreach/next is not allowed");
                        }
                        String value2 = new SpecVars(env, this.locals).shift(args[0]);
                        if (value2 != null && !"".equals(value2)) {
                            this.locals.put("%_", value2);
                            this._runCommand(i, label, arch, env, commandz);
                        }
                        this.locals.remove("%_");
                    } else {
                        throw new SpecProgramException(this, "This is a bug? Did not process '" + command.getOriginal() + "'");
                    }
                }
            }
        }
    }

    public void runConfig(String label, String arch, Map env) throws SpecProgramException, SpecParseException {
        this._run("", label, arch, env);
        if (this.tags.getTags().size() > 0) {
            throw new SpecProgramException(this, "Tag store is not empty. Do not use exportfunc from a @config.spec file.");
        }
        if (!this.state.empty()) {
            throw new SpecProgramException(this, "Stack is not empty. Make sure all objects are processed");
        }
    }

    public byte[] run(String label, String arch, Map env) throws SpecProgramException, SpecParseException {
        this._run("", label, arch, env);
        if (this.state.empty()) {
            throw new SpecProgramException(this, "Stack is empty. Where's the bytes I want to return?");
        }
        SpecObject obj = this.pop();
        if (!this.state.empty()) {
            throw new SpecProgramException(this, "Stack is not empty. Make sure all objects are processed");
        }
        return obj.getBytes();
    }

    public void handleException(RuntimeException rex) throws SpecProgramException {
        if (rex.getClass() != RuntimeException.class) {
            CrystalUtils.handleException(rex);
            throw new SpecProgramException(this, rex.getClass().getName() + ": " + rex.getMessage());
        }
        throw new SpecProgramException(this, rex.getMessage());
    }

    public COFFObject createCOFF(SpecObject obj) throws SpecProgramException {
        COFFParser parser = new COFFParser();
        try {
            parser.parse(obj.getBytes());
        }
        catch (RuntimeException rex) {
            this.handleException(rex);
        }
        if (!this.ltarch.equals(parser.getObject().getMachine())) {
            throw new SpecProgramException(this, parser.getObject().getMachine() + " COFF arch differs from " + this.ltarg + " .spec target");
        }
        return parser.getObject();
    }

    public File getFileFromArg(String arg) throws SpecProgramException {
        File temp;
        File file = temp = new File(arg).isAbsolute() ? new File(arg) : new File(new File(this.parent).getParentFile(), arg);
        if (!temp.exists()) {
            throw new SpecProgramException(this, "File does not exist " + temp.getPath());
        }
        if (temp.isDirectory()) {
            throw new SpecProgramException(this, "File is a folder " + temp.getPath());
        }
        if (!temp.canRead()) {
            throw new SpecProgramException(this, "File is not readable " + temp.getPath());
        }
        return temp;
    }

    public File getOutFileFromArg(String arg) throws SpecProgramException {
        File temp = new File(".", arg);
        if (temp.isDirectory()) {
            throw new SpecProgramException(this, "Out file is a folder " + temp.getPath());
        }
        if (temp.exists() && !temp.canWrite()) {
            throw new SpecProgramException(this, "Out file is not writable " + temp.getPath());
        }
        return temp;
    }

    public void putEnv(Map env, String key, byte[] data) throws SpecProgramException {
        if (!key.startsWith("$")) {
            throw new SpecProgramException(this, "Invalid argument. Try: $" + key);
        }
        if (env.containsKey(key)) {
            throw new SpecProgramException(this, key + " is already present in environment. Can't overwrite");
        }
        env.put(key, data);
    }

    public byte[] getFromEnv(Map env, String key) throws SpecProgramException {
        if (!key.startsWith("$")) {
            throw new SpecProgramException(this, "Invalid argument. Try: $" + key);
        }
        if (env.containsKey(key)) {
            Object temp = env.get(key);
            if (temp.getClass().isArray() && temp.getClass().getComponentType() == Byte.TYPE) {
                return (byte[])temp;
            }
            throw new SpecProgramException(this, "Var " + key + " is not a byte[]");
        }
        throw new SpecProgramException(this, "Var " + key + " is not set");
    }
}

