/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import crystalpalace.spec.LinkSpec;
import crystalpalace.util.CommandParser;
import crystalpalace.util.CrystalUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SpecParser {
    protected static Set commands = CrystalUtils.toSet("export, generate, patch, preplen, prepsum, link, load, make, push, xor, rc4, run, import, disassemble, coffparse, merge, reladdr, dfr, fixptrs, mergelib, fixbss, remap, attach, redirect, preserve, addhook, filterhooks, protect, exportfunc, optout, set, setg, foreach, echo, call, modcall, resolve, pack, linkfunc, next");
    protected static Set commandsv = CrystalUtils.toSet("push, xor, rc4, filterhooks");
    protected static Set fullcmds = CrystalUtils.toSet("make coff, make object, make pic, make pic64, export, preplen, prepsum, merge");
    protected static Set arg1cmds = CrystalUtils.toSet("import, link, load, disassemble, coffparse, reladdr, fixptrs, fixbss, mergelib, protect, addhook, linkfunc");
    protected static Set arg2cmds = CrystalUtils.toSet("attach, redirect, remap, preserve, addhook, exportfunc, optout, load, patch");
    protected static Set labels = CrystalUtils.toSet("x86, x64, x86.o, x64.o, x86.dll, x64.dll");
    protected static Set options = CrystalUtils.toSet("+optimize,+disco,+mutate,+gofirst,+blockparty,+shatter,+regdance");
    protected static Set optcmds = CrystalUtils.toSet("make object, make pic, make pic64, make coff");
    protected LinkSpec spec = null;
    protected List errors = new LinkedList();
    protected String parent = "";

    public LinkSpec getSpec() {
        return this.spec;
    }

    public List getErrors() {
        return this.errors;
    }

    public void error(String msg, int lineNo) {
        this.errors.add(msg + " at line " + lineNo);
    }

    public int parseInt(CommandParser parser, String arg, int x) {
        int val = CrystalUtils.parseInt(arg, -1);
        if (val == -1) {
            this.error("Invalid argument for '" + parser.getOriginal() + "'. " + arg + " is not a valid number", x + 1);
        } else if (val < 0) {
            this.error("Invalid argument for '" + parser.getOriginal() + "'. " + arg + " is a negative number", x + 1);
        } else if (val == 0) {
            this.error("Invalid argument for '" + parser.getOriginal() + "'. " + arg + " is zero", x + 1);
        }
        return val;
    }

    public boolean isValidLabel(String name) {
        for (String cand : labels) {
            if (!name.equals(cand) && !name.endsWith("." + cand)) continue;
            return true;
        }
        return false;
    }

    public void parse(String content, String parent) {
        this.spec = new LinkSpec(this, parent);
        String label = "";
        String[] contents = content.split("\\n");
        for (int x = 0; x < contents.length; ++x) {
            contents[x] = contents[x].trim();
            if (contents[x].startsWith("#")) continue;
            if (contents[x].endsWith(":") && contents[x].indexOf(32) == -1) {
                label = contents[x].substring(0, contents[x].length() - 1);
                if (label.startsWith(".")) {
                    this.error("Invalid label '" + label + "' - acceptable labels are <name.>[x86|x64]<.o|.dll> - don't start name with a '.'", x + 1);
                } else if (!this.isValidLabel(label)) {
                    this.error("Invalid label '" + label + "' - acceptable labels are <name.>[x86|x64]<.o|.dll>", x + 1);
                }
                if (!this.spec.program.targets(label)) continue;
                this.error("Label " + label + " is already defined", x + 1);
                continue;
            }
            if ("".equals(contents[x])) continue;
            CommandParser parser = new CommandParser(contents[x]);
            String command = parser.getCommand();
            String[] args = parser.getArguments();
            this.parseOne(label, contents[x], x);
        }
    }

    public void parseOne(String label, String content, int x) {
        CommandParser parser = new CommandParser(content);
        String command = parser.getCommand();
        String[] args = parser.getArguments();
        if ("describe".equals(command)) {
            if (parser.getArguments().length == 0) {
                this.error("Command '" + command + "' requires an argument", x + 1);
            } else {
                this.spec.description = parser.getArguments()[0];
            }
        } else if ("author".equals(command)) {
            if (parser.getArguments().length == 0) {
                this.error("Command '" + command + "' requires an argument", x + 1);
            } else {
                this.spec.author = parser.getArguments()[0];
            }
        } else if ("name".equals(command)) {
            if (parser.getArguments().length == 0) {
                this.error("Command '" + command + "' requires an argument", x + 1);
            } else {
                this.spec.name = parser.getArguments()[0];
            }
        } else {
            if ("".equals(label)) {
                this.error("Commands must exist under an 'x86:' or 'x64:' label", x + 1);
                return;
            }
            int alen = parser.getArguments().length;
            if (command.startsWith(".")) {
                this.spec.program.getInstructionsForLabel(label).add(parser);
                return;
            }
            if (!commands.contains(command)) {
                this.error("Invalid command '" + command + "'", x + 1);
                return;
            }
            if (fullcmds.contains(parser.getFullCommand())) {
                this.spec.program.getInstructionsForLabel(label).add(parser);
                return;
            }
            if (parser.hasOptions()) {
                for (String opt : parser.getOptions()) {
                    if (options.contains(opt)) continue;
                    this.error("Invalid option " + opt + " for '" + parser.getFullCommand() + "'", x + 1);
                }
                if (optcmds.contains(parser.getFullCommand())) {
                    this.spec.program.getInstructionsForLabel(label).add(parser);
                } else {
                    this.error("Command '" + command + "' does not accept +options " + parser.getOptions(), x + 1);
                }
                return;
            }
            if (commandsv.contains(command) && alen == 1) {
                this.spec.program.getInstructionsForLabel(label).add(parser);
                return;
            }
            if (arg1cmds.contains(command) && alen == 1) {
                this.spec.program.getInstructionsForLabel(label).add(parser);
                return;
            }
            if (arg2cmds.contains(command) && alen == 2) {
                this.spec.program.getInstructionsForLabel(label).add(parser);
                return;
            }
            if ("dfr".equals(command) && (alen == 2 || alen == 3)) {
                Set valid = CrystalUtils.toSet("ror13, strings");
                if (valid.contains(args[1])) {
                    this.spec.program.getInstructionsForLabel(label).add(parser);
                } else {
                    this.error("Invalid method '" + args[1] + "' for '" + parser.getOriginal() + "'. Use 'ror13' or 'strings'", x + 1);
                }
                return;
            }
            if ("generate".equals(command) && alen == 2) {
                int val = this.parseInt(parser, args[1], x);
                if (val != -1) {
                    this.spec.program.getInstructionsForLabel(label).add(parser);
                }
                return;
            }
            if ("pack".equals(command) && alen >= 2) {
                this.spec.program.getInstructionsForLabel(label).add(parser);
                return;
            }
            if ("resolve".equals(command) && alen == 1) {
                String[] types = parser.getTypes();
                if (!args[0].startsWith("%")) {
                    this.error("Invalid argument for '" + parser.getOriginal() + "'. Try \"%" + args[0] + "\"", x + 1);
                } else if (!"string".equals(types[0])) {
                    this.error("Quotes required for variable: " + command + " \"" + args[0] + "\"", x + 1);
                } else {
                    this.spec.program.getInstructionsForLabel(label).add(parser);
                }
                return;
            }
            if (CrystalUtils.toSet("set, setg").contains(command) && alen == 2) {
                String[] types = parser.getTypes();
                if (!args[0].startsWith("%")) {
                    this.error("Invalid argument for '" + parser.getOriginal() + "'. Try \"%" + args[0] + "\"", x + 1);
                } else if (!"string".equals(types[0])) {
                    this.error("Quotes required for variable: " + command + " \"" + args[0] + "\"", x + 1);
                } else {
                    this.spec.program.getInstructionsForLabel(label).add(parser);
                }
                return;
            }
            if ("run".equals(command) && alen >= 1) {
                this.spec.program.getInstructionsForLabel(label).add(parser);
                return;
            }
            if ("call".equals(command) && alen >= 2) {
                if (args[1].startsWith(".")) {
                    this.error("Invalid label for '" + parser.getOriginal() + "' - callable labels do not begin with a '.'", x + 1);
                } else {
                    this.spec.program.getInstructionsForLabel(label).add(parser);
                }
                return;
            }
            if ("echo".equals(command) && alen >= 1) {
                this.spec.program.getInstructionsForLabel(label).add(parser);
                return;
            }
            if ("foreach".equals(command) && alen == 2) {
                this.spec.program.getInstructionsForLabel(label).add(parser);
                this.parseOne(label, args[1], x);
                return;
            }
            if ("next".equals(command) && alen == 2) {
                String[] types = parser.getTypes();
                if (!args[0].startsWith("%")) {
                    this.error("Invalid argument for '" + parser.getOriginal() + "'. Try \"%" + args[0] + "\"", x + 1);
                } else if (!"string".equals(types[0])) {
                    this.error("Quotes required for variable: " + command + " \"" + args[0] + "\"", x + 1);
                } else {
                    this.spec.program.getInstructionsForLabel(label).add(parser);
                    this.parseOne(label, args[1], x);
                }
                return;
            }
            String hint = "";
            if ("export".equals(command)) {
                hint = "export";
            } else if ("generate".equals(command)) {
                hint = "generate $KEY 1024";
            } else if ("link".equals(command)) {
                hint = "link 'section_name'";
            } else if ("linkfunc".equals(command)) {
                hint = "linkfunc 'symbol'";
            } else if ("load".equals(command)) {
                hint = "load 'path/to/file'";
            } else if ("run".equals(command)) {
                hint = "run 'path/to/file' [args...]";
            } else if ("call".equals(command)) {
                hint = "call 'path/to/file' 'name' [args...]";
            } else if ("mergelib".equals(command)) {
                hint = "mergelib 'path/to/file.zip'";
            } else if ("disassemble".equals(command)) {
                hint = "disassemble out.txt";
            } else if ("coffparse".equals(command)) {
                hint = "coffparse out.txt";
            } else if ("make".equals(command)) {
                hint = "make pic, make coff, make object";
            } else if ("push".equals(command)) {
                hint = "push $DLL";
            } else if ("xor".equals(command)) {
                hint = "xor $KEY";
            } else if ("rc4".equals(command)) {
                hint = "rc4 $KEY";
            } else if ("patch".equals(command)) {
                hint = "patch 'symbol' $VAR";
            } else if ("import".equals(command)) {
                hint = "import 'LoadLibraryA, GetProcAddress, ...'";
            } else if ("reladdr".equals(command)) {
                hint = "reladdr '_go'";
            } else if ("dfr".equals(command)) {
                hint = "dfr 'resolver_func' 'ror13|strings' ['mod1, mod2']";
            } else if ("fixptrs".equals(command)) {
                hint = "fixptrs '_getretaddr'";
            } else if ("fixbss".equals(command)) {
                hint = "fixbss 'getbssaddr'";
            } else if ("remap".equals(command)) {
                hint = "remap 'old_symbol' 'new_symbol'";
            } else if ("redirect".equals(command)) {
                hint = "redirect 'target' 'hook'";
            } else if ("attach".equals(command)) {
                hint = "attach 'MODULE$function' 'hook'";
            } else if ("preserve".equals(command)) {
                hint = "preserve 'target|MODULE$Function' 'func1, func2, func3'";
            } else if ("addhook".equals(command)) {
                hint = "addhook 'MODULE$Function' ['hook']";
            } else if ("filterhooks".equals(command)) {
                hint = "filterhooks $DLL|$OBJECT";
            } else if ("protect".equals(command)) {
                hint = "protect 'func1, func2, etc.'";
            } else if ("exportfunc".equals(command)) {
                hint = "exportfunc 'function' '__tag_function'";
            } else if ("optout".equals(command)) {
                hint = "optout 'target' 'hook1, hook2, hook3'";
            } else if ("setg".equals(command)) {
                hint = "setg '%var' 'value'";
            } else if ("set".equals(command)) {
                hint = "set '%var' 'value'";
            } else if ("resolve".equals(command)) {
                hint = "resolve '%var'";
            } else if ("foreach".equals(command)) {
                hint = "foreach 'val1, val2': command %_";
            } else if ("next".equals(command)) {
                hint = "next '%var': command %_";
            } else if ("echo".equals(command)) {
                hint = "echo 'message'";
            } else if ("pack".equals(command)) {
                hint = "pack $DEST 'template' 'arg1' 'arg2' ...";
            }
            if (alen == 0) {
                this.error("Command " + command + " missing arguments, try '" + hint + "'", x + 1);
            } else {
                this.error("Command " + command + " invalid arguments, try '" + hint + "'", x + 1);
            }
        }
    }
}

