/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import crystalpalace.spec.SpecProgram;
import crystalpalace.spec.SpecProgramException;
import crystalpalace.util.Concat;
import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Packer;
import java.math.BigInteger;
import java.util.Map;

public class SpecPack {
    protected SpecProgram program;
    protected String format;

    public SpecPack(SpecProgram program, String format) {
        this.program = program;
        this.format = format;
    }

    protected BigInteger decodeNumber(String _val, int maxb) {
        int needs;
        boolean negate = false;
        int radix = 10;
        String val = _val;
        if (val.startsWith("-")) {
            negate = true;
            val = val.substring(1);
        } else if (val.startsWith("+")) {
            val = val.substring(1);
        }
        if (val.startsWith("0x")) {
            radix = 16;
            val = val.substring(2);
        } else if (val.startsWith("0")) {
            radix = 8;
            val = val.substring(1);
        } else if (val.startsWith("#")) {
            radix = 16;
            val = val.substring(1);
        }
        BigInteger number = null;
        try {
            number = new BigInteger(val, radix);
            needs = number.bitLength();
        }
        catch (NumberFormatException nex) {
            throw new RuntimeException("Can't decode " + _val + " as base " + radix + " number");
        }
        if (negate) {
            number = number.negate();
        }
        if (needs > maxb) {
            throw new RuntimeException("Number " + _val + " (base " + radix + ") needs " + needs + " bits, max " + maxb);
        }
        return number;
    }

    public byte[] processArg(Walker walker, Map env) throws SpecProgramException {
        Packer packer = new Packer();
        packer.little();
        switch (walker.getTemplate()) {
            case '@': {
                return new byte[0];
            }
            case 'x': {
                return new byte[1];
            }
            case 'b': {
                return this.program.getFromEnv(env, walker.getArg());
            }
            case 's': {
                packer.addShort(this.decodeNumber(walker.getArg(), 16).shortValue());
                return packer.getBytes();
            }
            case 'i': {
                packer.addInt(this.decodeNumber(walker.getArg(), 32).intValue());
                return packer.getBytes();
            }
            case 'l': {
                packer.addLong(this.decodeNumber(walker.getArg(), 64).longValue());
                return packer.getBytes();
            }
            case 'p': {
                if ("x64".equals(this.program.ltarch)) {
                    packer.addLong(this.decodeNumber(walker.getArg(), 64).longValue());
                } else {
                    packer.addInt(this.decodeNumber(walker.getArg(), 32).intValue());
                }
                return packer.getBytes();
            }
            case 'z': {
                return CrystalUtils.toBytes(walker.getArg() + '\u0000', "UTF-8");
            }
            case 'Z': {
                return CrystalUtils.toBytes(walker.getArg() + '\u0000', "UTF-16LE");
            }
        }
        throw new RuntimeException("pack: unimplemented templated char " + walker.getTemplate());
    }

    public byte[] getLength(byte[] arg) {
        Packer packer = new Packer();
        packer.little();
        packer.addInt(arg.length);
        return packer.getBytes();
    }

    public byte[] apply(String[] args, int argStart, Map env) throws SpecProgramException {
        Concat result = new Concat();
        Walker walker = new Walker(this.format, args, argStart);
        while (walker.next()) {
            byte[] data = this.processArg(walker, env);
            switch (walker.getOp()) {
                case 2: {
                    if ("x64".equals(this.program.ltarch)) {
                        result.align(8);
                        break;
                    }
                    result.align(4);
                    break;
                }
                case 3: {
                    result.align(4);
                    break;
                }
                case 4: {
                    result.align(8);
                    break;
                }
                case 0: {
                    result.add(data);
                    break;
                }
                case 1: {
                    result.add(this.getLength(data));
                    result.add(data);
                }
            }
        }
        return result.get();
    }

    private static class Walker {
        public static final int OP_APPEND_DATA = 0;
        public static final int OP_APPEND_LENGTH_DATA = 1;
        public static final int OP_ALIGN_NATURAL = 2;
        public static final int OP_ALIGN_4 = 3;
        public static final int OP_ALIGN_8 = 4;
        protected char template;
        protected int op;
        protected String arg;
        protected String format;
        protected String[] args;
        protected int x;
        protected int z;
        protected int start;

        public Walker(String format, String[] args, int argStart) {
            this.format = format;
            this.args = args;
            this.x = 0;
            this.z = argStart;
            this.start = argStart;
        }

        public int getOp() {
            return this.op;
        }

        public char getTemplate() {
            return this.template;
        }

        public String getArg() {
            return this.arg;
        }

        protected boolean nextAlign() {
            if (this.x >= this.format.length()) {
                throw new RuntimeException("pack: @ character is missing alignment argument (e.g., @4, @8, @n)");
            }
            this.template = (char)64;
            switch (this.format.charAt(this.x)) {
                case 'n': {
                    this.op = 2;
                    ++this.x;
                    return true;
                }
                case '4': {
                    this.op = 3;
                    ++this.x;
                    return true;
                }
                case '8': {
                    this.op = 4;
                    ++this.x;
                    return true;
                }
            }
            throw new RuntimeException("pack: invalid alignment '@" + this.format.charAt(this.x) + "'. Use @4, @8, or @n");
        }

        public boolean next() {
            this.op = 0;
            this.arg = null;
            while (this.x < this.format.length()) {
                switch (this.format.charAt(this.x)) {
                    case '@': {
                        ++this.x;
                        return this.nextAlign();
                    }
                    case '#': {
                        this.op = 1;
                        break;
                    }
                    case 'Z': 
                    case 'b': 
                    case 'i': 
                    case 'l': 
                    case 'p': 
                    case 's': 
                    case 'z': {
                        this.template = this.format.charAt(this.x);
                        if (this.z < this.args.length) {
                            this.arg = this.args[this.z];
                            ++this.z;
                        } else {
                            throw new RuntimeException("pack: no argument for " + this.format.charAt(this.x) + " at position " + this.x);
                        }
                        ++this.x;
                        return true;
                    }
                    case 'x': {
                        this.template = this.format.charAt(this.x);
                        ++this.x;
                        return true;
                    }
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new RuntimeException("pack: unknown template " + this.format.charAt(this.x) + " at position " + this.x);
                    }
                }
                ++this.x;
            }
            if (this.z < this.args.length) {
                throw new RuntimeException("pack: format string " + this.format + " only consumed " + (this.z - this.start) + " of " + (this.args.length - this.start) + " arguments");
            }
            return false;
        }
    }
}

