/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import crystalpalace.spec.Capability;
import crystalpalace.spec.LinkSpec;
import crystalpalace.spec.SpecLogger;
import crystalpalace.spec.SpecMessage;
import crystalpalace.spec.SpecParseException;
import crystalpalace.spec.SpecProgramException;
import crystalpalace.util.CrystalUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class LinkerCLI
implements SpecLogger {
    protected Map env = new HashMap();
    protected String specfile = null;
    protected Capability capability = null;
    protected boolean resolveNext = false;

    protected LinkerCLI(String specfile, Capability capability) {
        this.specfile = specfile;
        this.capability = capability;
    }

    public void processInclude(String file) throws SpecParseException, SpecProgramException, IOException {
        LinkSpec spec = LinkSpec.Parse(file);
        spec.addLogger(this);
        spec.runConfig(this.capability, this.env);
    }

    public void processKey(String key, String value) {
        try {
            byte[] temp = CrystalUtils.hexToBytes(value);
            this.env.put(key, temp);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not convert " + key + " to byte[]: " + ex.getMessage());
        }
    }

    @Override
    public void logSpecMessage(SpecMessage message) {
        CrystalUtils.print_info(message.toString());
    }

    public void processVar(String key, String value) throws IOException {
        if (this.resolveNext) {
            LinkedList<String> vals = new LinkedList<String>();
            for (String partial : CrystalUtils.toList(value)) {
                File temp = new File(partial);
                vals.add(temp.getCanonicalPath());
            }
            this.env.put(key, String.join((CharSequence)", ", vals));
            this.resolveNext = false;
        } else {
            this.env.put(key, value);
        }
    }

    protected String[] breakApart(String val) {
        StringBuffer key = new StringBuffer();
        StringBuffer value = new StringBuffer();
        int x = 0;
        while (true) {
            if (x >= val.length()) {
                throw new RuntimeException("Argument " + val + " is not $KEY=######## or %var=\"string\" format.");
            }
            if (val.charAt(x) == '=') {
                ++x;
                break;
            }
            key.append(val.charAt(x));
            ++x;
        }
        while (x < val.length()) {
            value.append(val.charAt(x));
            ++x;
        }
        String[] rv = new String[]{key.toString(), value.toString()};
        return rv;
    }

    public void processArg(String arg) throws SpecParseException, SpecProgramException, IOException {
        if (this.resolveNext && !arg.startsWith("%")) {
            throw new RuntimeException("-r must be followed by %key=value");
        }
        if ("".equals(arg)) {
            return;
        }
        if (arg.startsWith("@")) {
            this.processInclude(arg.substring(1));
            return;
        }
        if (arg.equals("-r")) {
            this.resolveNext = true;
            return;
        }
        if (arg.startsWith("-r")) {
            this.resolveNext = true;
            this.processArg(arg.substring(2));
            return;
        }
        String[] split = this.breakApart(arg);
        if (split[0].startsWith("$")) {
            this.processKey(split[0], split[1]);
        } else if (split[0].startsWith("%")) {
            this.processVar(split[0], split[1]);
        } else {
            if (split[0].equals("") && arg.startsWith("=")) {
                throw new RuntimeException("Key is empty in " + arg + " - try escaping \\$");
            }
            this.processKey("$" + split[0], split[1]);
        }
    }

    public byte[] run() throws SpecParseException, SpecProgramException, IOException {
        LinkSpec spec = LinkSpec.Parse(this.specfile);
        spec.addLogger(this);
        return spec.run(this.capability, this.env);
    }

    protected static String varHelp() {
        return "\n\n\tArguments:\n\t\t@config.spec\tRun a specification file to configure variables.\n\t\t-r %key=val\tResolve paths in %key relative to $CWD.\n\n\tData Variables ($VARS):\n\t\tA=04030201\tplaces { 0x04, 0x03, 0x02, 0x01 } into $A.\n\n\t\t* Note: The '$' prefix is optional to avoid shell escaping.\n\t\t* Warning: Bytes are written left-to-right.\n\t\t  Account for little endian when writing ints, longs, pointers, etc.\n\n\tString Variables (%VARS):\n\t\t%key=value\tSets %key to the literal string \"value\"";
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            CrystalUtils.print_error("Please use ./link or ./piclink");
            return;
        }
        String command = args[0];
        if (!CrystalUtils.toSet("run, buildPic").contains(command)) {
            CrystalUtils.print_error("Unrecognized verb '" + command + "'");
            return;
        }
        if (args.length < 4) {
            if ("run".equals(command)) {
                CrystalUtils.print_error("./link <loader.spec> <file.dll|file.o> <out.bin> [A=hex] [%B=val] [@config.spec]\n\tApply the specified .spec file to build a PIC DLL or COFF loader for file" + LinkerCLI.varHelp());
            } else if ("buildPic".equals(command)) {
                CrystalUtils.print_error("./piclink <build.spec> [label.]<x86|x64> <out.bin> [A=hex] [%B=val] [@config.spec]\n\tRun the specified .spec file to assemble a PIC program" + LinkerCLI.varHelp());
            }
            return;
        }
        try {
            Capability capability = null;
            if ("run".equals(command)) {
                capability = Capability.Parse(CrystalUtils.readFromFile(args[2]));
            } else if ("buildPic".equals(command)) {
                capability = Capability.None(args[2]);
            }
            LinkerCLI program = new LinkerCLI(args[1], capability);
            for (int x = 4; x < args.length; ++x) {
                program.processArg(args[x]);
            }
            CrystalUtils.writeToFile(args[3], program.run());
        }
        catch (SpecParseException specex) {
            CrystalUtils.print_error(specex.toString());
        }
        catch (SpecProgramException progex) {
            CrystalUtils.print_error(progex.toString());
        }
        catch (NullPointerException npe) {
            CrystalUtils.handleException(npe);
        }
        catch (RuntimeException runex) {
            CrystalUtils.print_error(runex.getMessage());
        }
        catch (IOException ex) {
            CrystalUtils.reportException(ex);
        }
    }
}

