/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import crystalpalace.spec.Capability;
import crystalpalace.spec.SpecLogger;
import crystalpalace.spec.SpecParseException;
import crystalpalace.spec.SpecParser;
import crystalpalace.spec.SpecProgram;
import crystalpalace.spec.SpecProgramException;
import crystalpalace.util.CrystalUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class LinkSpec {
    protected String parent = ".";
    protected String author = "";
    protected String name = "";
    protected String description = "";
    protected SpecProgram program;

    public void addLogger(SpecLogger logger) {
        this.program.addLogger(logger);
    }

    public void removeLogger(SpecLogger logger) {
        this.program.removeLogger(logger);
    }

    public String getFile() {
        return this.parent;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean targets(String arch) {
        return this.program.targets(arch);
    }

    protected LinkSpec(SpecParser parser, String parent) {
        this.parent = parent;
        this.name = new File(parent).getName();
        if ("loader.spec".equals(this.name)) {
            this.name = new File(parent).getAbsoluteFile().getParentFile().getName();
        }
        this.program = new SpecProgram(parent);
    }

    @Deprecated
    public byte[] run(byte[] capability, Map vars) throws SpecParseException, SpecProgramException {
        return this.run(Capability.Parse(capability), vars);
    }

    public byte[] run(Capability capability, Map vars) throws SpecParseException, SpecProgramException {
        HashMap<String, byte[]> env = new HashMap<String, byte[]>();
        if (vars != null) {
            env.putAll(vars);
        }
        if (capability.hasCapability()) {
            env.put(capability.getKey(), capability.getContents());
        }
        this.program.reset();
        return this.program.run(capability.getLabel(), capability.getArch(), env);
    }

    public Map runConfig(Capability capability, Map vars) throws SpecParseException, SpecProgramException {
        if (capability.hasCapability()) {
            vars.put(capability.getKey(), capability.getContents());
        }
        this.program.reset();
        this.program.runConfig(capability.getLabel(), capability.getArch(), vars);
        return vars;
    }

    @Deprecated
    public byte[] runDll(byte[] dll_arg, Map vars) throws SpecParseException, SpecProgramException {
        return this.run(Capability.ParseDll(dll_arg), vars);
    }

    @Deprecated
    public byte[] runObject(byte[] object_arg, Map vars) throws SpecParseException, SpecProgramException {
        return this.run(Capability.ParseObject(object_arg), vars);
    }

    @Deprecated
    public byte[] buildPic(String arch, Map vars) throws SpecParseException, SpecProgramException {
        return this.run(Capability.None(arch), vars);
    }

    public static LinkSpec Parse(String parent, String content) throws SpecParseException {
        SpecParser parser = new SpecParser();
        parser.parse(content, parent);
        if (parser.getErrors().size() > 0) {
            throw new SpecParseException(parser, parent);
        }
        return parser.getSpec();
    }

    public static LinkSpec Parse(String parent) throws SpecParseException, IOException {
        return LinkSpec.Parse(parent, CrystalUtils.readStringFromFile(parent));
    }
}

