/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.spec;

import crystalpalace.coff.COFFObject;
import crystalpalace.coff.COFFParser;
import crystalpalace.pe.PEObjectSimple;
import crystalpalace.util.ByteWalker;
import crystalpalace.util.CrystalUtils;

public class Capability {
    protected String key;
    protected byte[] contents;
    protected String label;
    protected String arch;

    protected Capability(String key, byte[] contents, String label, String arch) {
        this.key = key;
        this.contents = contents;
        this.label = label;
        this.arch = arch;
    }

    public String getKey() {
        return this.key;
    }

    public byte[] getContents() {
        return this.contents;
    }

    public String getLabel() {
        return this.label;
    }

    public String getArch() {
        return this.arch;
    }

    public boolean hasCapability() {
        return this.key != null;
    }

    public boolean isObject() {
        return "$OBJECT".equals(this.key);
    }

    public boolean isDll() {
        return "$DLL".equals(this.key);
    }

    public static Capability None(String archOrLabel) {
        String arch = "";
        if (CrystalUtils.toSet("x86, x64").contains(archOrLabel)) {
            arch = archOrLabel;
        } else if (archOrLabel.endsWith(".x86")) {
            arch = "x86";
        } else if (archOrLabel.endsWith(".x64")) {
            arch = "x64";
        } else {
            throw new RuntimeException("Label " + archOrLabel + " must end with .x86/.x64 or be x86/x64");
        }
        return new Capability(null, new byte[0], archOrLabel, arch);
    }

    public static Capability ParseObject(byte[] object) {
        COFFObject coff = null;
        try {
            coff = new COFFParser().parse(object).getObject();
        }
        catch (RuntimeException rex) {
            throw new RuntimeException("Invalid Object: " + rex.getMessage());
        }
        return new Capability("$OBJECT", object, coff.getMachine() + ".o", coff.getMachine());
    }

    public static Capability ParseDll(byte[] dll) {
        PEObjectSimple obj = new PEObjectSimple(dll);
        return new Capability("$DLL", dll, obj.getMachine() + ".dll", obj.getMachine());
    }

    public static Capability Parse(byte[] capability) {
        ByteWalker peek = new ByteWalker(capability);
        int magic = peek.readShort();
        if (magic == 23117) {
            return Capability.ParseDll(capability);
        }
        if (magic == 34404 || magic == 332) {
            return Capability.ParseObject(capability);
        }
        throw new RuntimeException("Argument is not a COFF or DLL.");
    }

    public String toString() {
        return "Capability " + this.arch + " " + this.key + " (label: " + this.label + ")";
    }
}

