/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.pe;

import crystalpalace.coff.COFFObject;
import crystalpalace.coff.COFFVisitor;
import crystalpalace.coff.COFFWalker;
import crystalpalace.pe.OptionalHeader;
import crystalpalace.pe.PEVisitor;
import crystalpalace.util.ByteWalker;
import crystalpalace.util.CrystalUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PEWalker
implements COFFVisitor {
    protected ByteWalker walker;
    protected COFFObject object;
    protected OptionalHeader ntheaders;
    protected byte[] image;
    protected String arch;

    @Override
    public void visit(COFFWalker.Header header) {
    }

    @Override
    public void visit(COFFWalker.Section section) {
        byte[] src = section.getRawData();
        int dstIdx = (int)section.getVirtualAddress();
        System.arraycopy(src, 0, this.image, dstIdx, src.length);
    }

    @Override
    public void visit(COFFWalker.Symbol symbol) {
    }

    @Override
    public void visit(COFFWalker.Relocation reloc) {
    }

    @Override
    public void visitOH(byte[] data) {
        this.ntheaders = new OptionalHeader(data);
        this.image = new byte[(int)this.ntheaders.getSizeOfImage()];
    }

    public void processImports(PEVisitor visitor) {
        ImageImportDescriptor lib;
        OptionalHeader.ImageDataDirectory dir = this.ntheaders.getDataDirectory(1);
        ByteWalker impwalker = new ByteWalker(this.image);
        impwalker.GoTo((int)dir.getVirtualAddress());
        while ((lib = new ImageImportDescriptor(impwalker)).isValid()) {
            Iterator i = lib.getThunks().iterator();
            while (i.hasNext()) {
                visitor.visit(lib, (ImageThunkData)i.next());
            }
        }
    }

    public void start() {
        int Magic = this.walker.readShort();
        if (Magic != 23117) {
            throw new RuntimeException("File header is not MZ");
        }
        this.walker.skip(58);
        long e_lfanew = this.walker.readInt();
        this.walker.GoTo((int)e_lfanew);
        long pe_signature = this.walker.readInt();
        if (pe_signature != 17744L) {
            throw new RuntimeException("PE signature is not 'PE'\\x00\\x00");
        }
        int machine = this.walker.readShort();
        if (machine == 34404) {
            this.arch = "x64";
        } else if (machine == 332) {
            this.arch = "x86";
        } else if (machine == 43620) {
            this.arch = "arm64";
        } else {
            throw new RuntimeException("Unknown machine for DLL " + CrystalUtils.toHex(machine));
        }
        this.walker.Return();
        this.walker.GoTo((int)e_lfanew);
        this.walker.skip(4);
        new COFFWalker().walk(this.walker, (COFFVisitor)this);
        this.walker.Return();
        this.walker.GoTo((int)e_lfanew);
        this.walker.skip(4);
    }

    public void walk(byte[] content, PEVisitor visitor) {
        this.walker = new ByteWalker(content);
        this.start();
        visitor.visit(this.arch);
        this.processImports(visitor);
        visitor.visit(this.ntheaders);
    }

    public class ImageImportDescriptor {
        protected long OriginalFirstThunk;
        protected long TimeDateStamp;
        protected long ForwarderChain;
        protected long NameRVA;
        protected long FirstThunk;
        protected String NameStr;
        protected List thunks = new LinkedList();

        public ImageImportDescriptor(ByteWalker impwalker) {
            ImageThunkData thunk;
            this.OriginalFirstThunk = impwalker.readInt();
            this.TimeDateStamp = impwalker.readInt();
            this.ForwarderChain = impwalker.readInt();
            this.NameRVA = impwalker.readInt();
            this.FirstThunk = impwalker.readInt();
            if (this.NameRVA == 0L) {
                return;
            }
            impwalker.GoTo((int)this.NameRVA);
            this.NameStr = impwalker.readStringA();
            impwalker.Return();
            impwalker.GoTo((int)this.FirstThunk);
            while ((thunk = new ImageThunkData(impwalker)).isValid()) {
                this.thunks.add(thunk);
            }
            impwalker.Return();
        }

        public List getThunks() {
            return this.thunks;
        }

        public boolean isValid() {
            return this.NameRVA != 0L;
        }

        public String getName() {
            return this.NameStr;
        }
    }

    public class ImageThunkData {
        public static final long IMAGE_ORDINAL_FLAG = 0x80000000L;
        protected int address;
        protected String function;
        protected int ordinal;

        public ImageThunkData(ByteWalker impwalker) {
            long funcRVA;
            this.address = impwalker.getPosition();
            if (PEWalker.this.ntheaders.is64()) {
                funcRVA = impwalker.readInt();
                impwalker.skip(4);
            } else {
                funcRVA = impwalker.readInt();
            }
            if (funcRVA == 0L) {
                this.address = 0;
                this.function = null;
                this.ordinal = 0;
                return;
            }
            if ((funcRVA & 0x80000000L) == 0x80000000L) {
                this.function = null;
                this.ordinal = (int)funcRVA & 0xFFFF;
            } else {
                impwalker.GoTo((int)funcRVA);
                this.ordinal = impwalker.readShort();
                this.function = impwalker.readStringA();
                impwalker.Return();
            }
        }

        public boolean isValid() {
            return this.address != 0;
        }

        public int getAddress() {
            return this.address;
        }

        public String getName() {
            return this.function;
        }

        public int getOrdinal() {
            return this.ordinal;
        }
    }
}

