/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.pe;

import crystalpalace.pe.OptionalHeader;
import crystalpalace.pe.PEObject;
import crystalpalace.pe.PEVisitor;
import crystalpalace.pe.PEWalker;
import crystalpalace.util.CrystalUtils;

public class PEParser
implements PEVisitor {
    protected PEObject peobject = null;

    @Override
    public void visit(String arch) {
        this.peobject = new PEObject(arch);
    }

    @Override
    public void visit(PEWalker.ImageImportDescriptor lib, PEWalker.ImageThunkData func) {
        PEObject.PEImport imp = new PEObject.PEImport();
        imp.address = func.getAddress();
        imp.module = lib.getName();
        imp.function = func.getName();
        imp.ordinal = func.getOrdinal();
        this.peobject.imports.add(imp);
    }

    @Override
    public void visit(OptionalHeader ntheaders) {
        this.peobject.entrypoint = (int)ntheaders.getAddressOfEntryPoint();
    }

    public PEParser parse(byte[] data) {
        new PEWalker().walk(data, this);
        return this;
    }

    public PEObject getPEObject() {
        return this.peobject;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("./peparser [/path/to/file.dll]");
            return;
        }
        try {
            String desc = new PEParser().parse(CrystalUtils.readFromFile(args[0])).getPEObject().toString();
            CrystalUtils.print_info(desc);
        }
        catch (Exception ex) {
            CrystalUtils.handleException(ex);
        }
    }
}

