/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.pe;

import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Printer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PEObject {
    protected List imports = new LinkedList();
    protected String arch = "";
    protected int entrypoint = 0;

    public int getEntryPoint() {
        return this.entrypoint;
    }

    public List getImports() {
        return this.imports;
    }

    public PEObject(String arch) {
        this.arch = arch;
    }

    public String getMachine() {
        return this.arch;
    }

    public void toString(Printer printer) {
        printer.print("PE");
        printer.print("Machine", this.getMachine());
        printer.print("EntryPoint", this.getEntryPoint());
        printer.push("Imports");
        Iterator i = this.getImports().iterator();
        while (i.hasNext()) {
            printer.print(i.next().toString());
        }
        printer.pop();
    }

    public String toString() {
        Printer printer = new Printer();
        this.toString(printer);
        return printer.toString();
    }

    public static class PEImport {
        protected int address;
        protected String module;
        protected String function;
        protected int ordinal;

        public int getAddress() {
            return this.address;
        }

        public String getModule() {
            return this.module;
        }

        public String getFunction() {
            return this.function;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public boolean isOrdinal() {
            return this.function == null;
        }

        public String toString() {
            if (this.isOrdinal()) {
                return "Import " + CrystalUtils.toHex(this.getAddress()) + " " + this.getModule() + "$(#" + this.getOrdinal() + ")";
            }
            return "Import " + CrystalUtils.toHex(this.getAddress()) + " " + this.getModule() + "$" + this.getFunction();
        }
    }
}

