/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.pe;

import crystalpalace.util.ByteWalker;
import crystalpalace.util.CrystalUtils;

public class OptionalHeader {
    protected ByteWalker walker;
    public static final int IMAGE_NT_OPTIONAL_HDR32_MAGIC = 267;
    public static final int IMAGE_NT_OPTIONAL_HDR64_MAGIC = 523;
    protected int Magic;
    protected long AddressOfEntryPoint;
    protected long ImageBase;
    protected long SizeOfImage;
    protected long NumberOfRvaAndSizes;
    protected ImageDataDirectory[] DataDirectory;
    public static final int IMAGE_DIRECTORY_ENTRY_EXPORT = 0;
    public static final int IMAGE_DIRECTORY_ENTRY_IMPORT = 1;
    public static final int IMAGE_DIRECTORY_ENTRY_RESOURCE = 2;
    public static final int IMAGE_DIRECTORY_ENTRY_EXCEPTION = 3;
    public static final int IMAGE_DIRECTORY_ENTRY_SECURITY = 4;
    public static final int IMAGE_DIRECTORY_ENTRY_BASERELOC = 5;
    public static final int IMAGE_DIRECTORY_ENTRY_DEBUG = 6;
    public static final int IMAGE_DIRECTORY_ENTRY_ARCHITECTURE = 7;
    public static final int IMAGE_DIRECTORY_ENTRY_GLOBALPTR = 8;
    public static final int IMAGE_DIRECTORY_ENTRY_TLS = 9;
    public static final int IMAGE_DIRECTORY_ENTRY_LOAD_CONFIG = 10;
    public static final int IMAGE_DIRECTORY_ENTRY_BOUND_IMPORT = 11;
    public static final int IMAGE_DIRECTORY_ENTRY_IAT = 12;
    public static final int IMAGE_DIRECTORY_ENTRY_DELAY_IMPORT = 13;
    public static final int IMAGE_DIRECTORY_ENTRY_COM_DESCRIPTOR = 14;

    public boolean is64() {
        return this.Magic == 523;
    }

    public long getSizeOfImage() {
        return this.SizeOfImage;
    }

    public long getImageBase() {
        return this.ImageBase;
    }

    public long getAddressOfEntryPoint() {
        return this.AddressOfEntryPoint;
    }

    public ImageDataDirectory getDataDirectory(int x) {
        return this.DataDirectory[x];
    }

    public void parse64() {
        this.walker.skip(14);
        this.AddressOfEntryPoint = this.walker.readInt();
        this.walker.skip(4);
        this.ImageBase = this.walker.readLong();
        this.walker.skip(24);
        this.SizeOfImage = this.walker.readInt();
        this.walker.skip(12);
        this.walker.skip(32);
        this.walker.skip(4);
        this.NumberOfRvaAndSizes = this.walker.readInt();
    }

    public void parse32() {
        this.walker.skip(14);
        this.AddressOfEntryPoint = this.walker.readInt();
        this.walker.skip(8);
        this.ImageBase = this.walker.readInt();
        this.walker.skip(24);
        this.SizeOfImage = this.walker.readInt();
        this.walker.skip(12);
        this.walker.skip(16);
        this.walker.skip(4);
        this.NumberOfRvaAndSizes = this.walker.readInt();
    }

    public OptionalHeader(byte[] content) {
        this.walker = new ByteWalker(content);
        this.Magic = this.walker.readShort();
        if (this.Magic == 267) {
            this.parse32();
        } else if (this.Magic == 523) {
            this.parse64();
        } else {
            throw new RuntimeException("Optional Header starts with invalid Magic value " + CrystalUtils.toHex(this.Magic));
        }
        this.DataDirectory = new ImageDataDirectory[(int)this.NumberOfRvaAndSizes];
        int x = 0;
        while ((long)x < this.NumberOfRvaAndSizes) {
            this.DataDirectory[x] = new ImageDataDirectory();
            ++x;
        }
    }

    public class ImageDataDirectory {
        protected long VirtualAddress;
        protected long Size;

        public ImageDataDirectory() {
            this.VirtualAddress = OptionalHeader.this.walker.readInt();
            this.Size = OptionalHeader.this.walker.readInt();
        }

        public String toString() {
            return CrystalUtils.toHex(this.VirtualAddress) + " (" + this.Size + "b)";
        }

        public long getVirtualAddress() {
            return this.VirtualAddress;
        }

        public long getSize() {
            return this.Size;
        }
    }
}

