/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.merge;

import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import crystalpalace.export.SectionContainer;
import crystalpalace.merge.COFFList;
import crystalpalace.util.CrystalUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class COFFMerge {
    protected COFFObject object = null;
    protected COFFList objects = new COFFList();
    protected Map containers = new HashMap();

    public SectionContainer getContainer(String name) {
        if (!this.containers.containsKey(name)) {
            this.containers.put(name, new SectionContainer());
        }
        return (SectionContainer)this.containers.get(name);
    }

    public void merge(COFFObject mergeme) {
        if (this.object == null) {
            this.object = new COFFObject(mergeme.getMachine());
        }
        this.objects.add(mergeme);
    }

    protected Map.Entry findContainer(Section s) {
        for (Map.Entry entry : this.containers.entrySet()) {
            SectionContainer next = (SectionContainer)entry.getValue();
            if (!next.hasOffset(s)) continue;
            return entry;
        }
        return null;
    }

    protected void resolveRelocations(String sectname) {
        SectionContainer container = this.getContainer(sectname);
        Section section = this.object.getSection(sectname);
        Iterator i = section.getRelocations().iterator();
        while (i.hasNext()) {
            Relocation reloc = (Relocation)i.next();
            if (reloc.getRemoteSection() != section) continue;
            int relocva = (int)reloc.getVirtualAddress();
            int dataaddr = reloc.getRemoteSectionOffset();
            long reladdress = reloc.getVirtualAddress() + (long)reloc.getFromOffset();
            if (reloc.is_x64_rel32()) {
                CrystalUtils.putDWORD(section.getRawData(), relocva, dataaddr - (int)reladdress);
                i.remove();
                continue;
            }
            if (!reloc.is("x86", 20)) continue;
            CrystalUtils.putDWORD(section.getRawData(), relocva, dataaddr - (int)reladdress);
            i.remove();
        }
    }

    protected void createRelocations(String sectname) {
        SectionContainer container = this.getContainer(sectname);
        Section section = this.object.getSection(sectname);
        for (Relocation oldreloc : container.getRelocations()) {
            Relocation newreloc = new Relocation(section, oldreloc);
            long virtaddr = (long)container.getBase(oldreloc) + oldreloc.getVirtualAddress();
            newreloc.setVirtualAddress(virtaddr);
            if (oldreloc.getSymbol().isSectionName()) {
                Section sect = oldreloc.getRemoteSection();
                Map.Entry sectloc = this.findContainer(sect);
                String remotesymb = (String)sectloc.getKey();
                SectionContainer remotecont = (SectionContainer)sectloc.getValue();
                newreloc.setSymbolName(remotesymb);
                long offset = remotecont.getBase(sect) + oldreloc.getOffsetAsLong();
                CrystalUtils.putDWORD(section.getRawData(), (int)newreloc.getVirtualAddress(), (int)offset);
            } else if (newreloc.getSymbol() == null) {
                if (!oldreloc.getSymbol().isUndefinedSection()) {
                    throw new RuntimeException("Relocation [[" + oldreloc + "]] refers to symbol [[" + oldreloc.getSymbol() + "]] with section [[" + oldreloc.getRemoteSection() + "]]");
                }
                Symbol newsymb = new Symbol(this.object, null, oldreloc.getSymbol());
                this.object.getSymbols().put(newsymb.getName(), newsymb);
            }
            section.getRelocations().add(newreloc);
        }
    }

    protected void createSymbols(String sectname) {
        SectionContainer container = this.getContainer(sectname);
        Section section = this.object.getSection(sectname);
        for (Symbol oldsymbol : container.getSymbols()) {
            Symbol newsymbol = new Symbol(this.object, section, oldsymbol);
            long value = (long)container.getBase(oldsymbol) + oldsymbol.getValue();
            newsymbol.setValue(value);
            this.object.getSymbols().put(newsymbol.getName(), newsymbol);
        }
    }

    protected void createSection(String name, List entries) {
        SectionContainer container = this.getContainer(name);
        for (Section sect : entries) {
            container.add(sect, false);
        }
        Section s = new Section(this.object, name);
        byte[] rawdata = container.getRawData();
        s.setData(rawdata);
        this.object.getSections().put(name, s);
        Symbol sectsym = Symbol.createSectionSymbol(this.object, s, name);
        this.object.getSymbols().put(name, sectsym);
    }

    public COFFMerge finish() {
        this.objects.finish();
        for (Map.Entry entry : this.objects.getGroups().entrySet()) {
            String sectname = (String)entry.getKey();
            List sections = (List)entry.getValue();
            this.createSection(sectname, sections);
        }
        for (String sectname : this.containers.keySet()) {
            this.createSymbols(sectname);
        }
        for (String sectname : this.containers.keySet()) {
            this.createRelocations(sectname);
        }
        for (String sectname : this.containers.keySet()) {
            this.resolveRelocations(sectname);
        }
        return this;
    }

    public COFFObject getObject() {
        return this.object;
    }

    public void print() {
        System.out.println(this.getObject().toString());
    }
}

