/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.imports;

import crystalpalace.imports.ImportsCOFF;
import crystalpalace.imports.ImportsDLL;
import crystalpalace.util.ByteWalker;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Imports {
    public abstract List getImports();

    public Set getStrings() {
        HashSet<String> result = new HashSet<String>();
        for (Import next : this.getImports()) {
            result.add(next.toString());
        }
        return result;
    }

    public static Imports getImports(byte[] contents) {
        ByteWalker peek = new ByteWalker(contents);
        int magic = peek.readShort();
        if (magic == 23117) {
            return new ImportsDLL(contents);
        }
        if (magic == 34404 || magic == 332) {
            return new ImportsCOFF(contents);
        }
        throw new RuntimeException("Argument is not a COFF or DLL.");
    }

    protected Imports() {
    }

    public static class Import {
        protected String module;
        protected String function;

        public Import(String module, String function) {
            this.module = module;
            this.function = function;
        }

        public String getModule() {
            return this.module;
        }

        public String getFunction() {
            return this.function;
        }

        public String toString() {
            return this.module.toUpperCase() + "$" + this.function;
        }
    }
}

