/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import crystalpalace.export.ExportObject;
import crystalpalace.export.SectionContainer;
import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Logger;
import java.util.Iterator;

public class ProgramPIC {
    protected SectionContainer program = new SectionContainer();
    protected ExportObject object;

    public ProgramPIC(ExportObject object) {
        this.object = object;
    }

    public void checkGoFirst() {
        Symbol symb = null;
        if ("x86".equals(this.object.getMachine())) {
            symb = this.program.getSymbol("_go");
        } else if ("x64".equals(this.object.getMachine())) {
            symb = this.program.getSymbol("go");
        }
        if (symb == null) {
            return;
        }
        if (this.program.getBase(symb) == 0 && symb.getValue() == 0L) {
            return;
        }
        throw new RuntimeException("Entry symbol " + symb.getName() + " is not at position 0. Did your compiler re-order your functions? Compile with -fno-toplevel-reorder (GCC) or equiv. to disable.");
    }

    protected Section getKey(Relocation r) {
        if (this.object.getLinkedSection(r.getSymbolName()) != null) {
            Section s = this.object.getLinkedSection(r.getSymbolName());
            if (this.program.hasOffset(s)) {
                return s;
            }
        } else if (r.getRemoteSection() != null) {
            if (this.program.hasOffset(r.getRemoteSection())) {
                return r.getRemoteSection();
            }
            if (".rdata".equals(r.getSymbolName())) {
                if (this.object.getSection(".rdata").hasRelocations()) {
                    throw new RuntimeException("Can't process relocation for " + r.toSimpleString() + ". Did your compiler insert a jump table? Compile with -fno-jump-tables (GCC) or equiv. to disable.");
                }
                throw new RuntimeException("Can't process relocation for " + r.toSimpleString() + ". Did you try to use a \"string literal\" from PIC?");
            }
        }
        throw new RuntimeException("Can't process relocation for " + r.toSimpleString());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processRelocation(Relocation r, byte[] rawdata) {
        Section key = this.getKey(r);
        long reladdress = (long)this.program.getBase(key) - (r.getVirtualAddress() + (long)r.getFromOffset());
        int offset = r.getRemoteSectionOffset();
        int relocva = this.program.getBase(r) + (int)r.getVirtualAddress();
        if (r.is_x64_rel32()) {
            Logger.print_info("Relocation r: " + r);
            CrystalUtils.putDWORD(rawdata, relocva, (int)reladdress + offset);
            return;
        }
        if (!r.is("x86", 6)) {
            if (!r.is("x86", 20)) throw new RuntimeException("Can't offline process relocation " + r.toSimpleString());
            CrystalUtils.putDWORD(rawdata, relocva, (int)reladdress + offset);
            return;
        }
        if (this.object.hasX86Retaddr()) {
            CrystalUtils.putDWORD(rawdata, relocva, (int)reladdress + offset);
            return;
        }
        if (this.object.getLinkedSection(r.getSymbolName()) == null) throw new RuntimeException("Can't process relocation for symbol " + r.getReferencedSymbol().getName() + " at " + r.getFunction().relativeTo(r) + ". Use 'fixptrs \"_caller\"' in .spec to make this relocation usable.");
        throw new RuntimeException("Can't process relocation for linked section " + r.getSymbolName() + ". Use 'fixptrs \"_caller\"' in .spec to use this symbol without pointer hacks.");
    }

    public void addSections() {
    }

    public byte[] export() {
        this.program.add(this.object.getSection(".text"), false);
        this.checkGoFirst();
        this.addSections();
        Iterator i = this.object.getLinks().iterator();
        while (i.hasNext()) {
            this.program.add((Section)i.next(), false);
        }
        byte[] data = this.program.getRawData();
        for (Relocation r : this.program.getRelocations()) {
            this.processRelocation(r, data);
        }
        return data;
    }
}

