/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import crystalpalace.export.ExportObject;
import crystalpalace.export.FormatCOFF;
import crystalpalace.export.SectionContainer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProgramCOFF {
    protected ExportObject object;
    protected Map sections = new LinkedHashMap();
    protected List linked = new LinkedList();

    public ProgramCOFF(ExportObject object) {
        this.object = object;
        this.setupSections();
    }

    public int getSectionNumber(Section s) {
        if (".text".equals(s.getName())) {
            return 1;
        }
        if (".rdata".equals(s.getName())) {
            return 2;
        }
        if (".data".equals(s.getName())) {
            return 3;
        }
        if (".bss".equals(s.getName())) {
            return 4;
        }
        throw new RuntimeException("Invalid section: " + s.getName());
    }

    public void createSection(String name, boolean eXecutable) {
        SectionContainer container = new SectionContainer();
        if (this.object.getSection(name) != null) {
            container.add(this.object.getSection(name), false);
        }
        Iterator i = this.object.getExecutableLinks(eXecutable).iterator();
        while (i.hasNext()) {
            container.add((Section)i.next(), false);
        }
        Section section = container.toSection(name);
        for (Section sect : this.object.getExecutableLinks(eXecutable)) {
            String sname = sect.getName();
            long svalue = container.getBase(sect);
            if (eXecutable) {
                this.linked.add(Symbol.createFunctionSymbol(section, sname, svalue));
                continue;
            }
            this.linked.add(Symbol.createDataSymbol(section, sname, svalue));
        }
        this.sections.put(name, section);
    }

    public void setupSections() {
        this.createSection(".text", true);
        this.createSection(".rdata", false);
        if (this.object.getSection(".data") != null) {
            this.sections.put(".data", this.object.getSection(".data"));
        }
        if (this.object.getSection(".bss") != null) {
            this.sections.put(".bss", this.object.getSection(".bss"));
        }
    }

    public List getSections() {
        return new LinkedList(this.sections.values());
    }

    public List getStrings() {
        LinkedHashSet<Object> strings = new LinkedHashSet<Object>();
        strings.addAll(this.sections.keySet());
        for (Symbol temp : this.getSymbols()) {
            strings.add(temp.getName());
        }
        for (Relocation temp : this.getRelocations()) {
            strings.add(temp.getSymbolName());
        }
        return new LinkedList(strings);
    }

    public List getRelocations() {
        LinkedList results = new LinkedList();
        for (Section sect : this.sections.values()) {
            results.addAll(sect.getRelocations());
        }
        return results;
    }

    public List getSymbols() {
        LinkedList results = new LinkedList();
        for (Section sect : this.sections.values()) {
            results.addAll(sect.getSymbols());
        }
        results.addAll(this.linked);
        return results;
    }

    public byte[] export() {
        FormatCOFF packer = new FormatCOFF();
        packer.header(this.object.getMachine(), this.sections.size());
        for (Section sect : this.sections.values()) {
            packer.sectionHeader(sect);
        }
        for (Section sect : this.sections.values()) {
            packer.sectionData(sect);
        }
        packer.symbolTable(this);
        packer.stringTable(this);
        return packer.getBytes();
    }
}

