/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.export.ExportObject;
import crystalpalace.imports.Imports;
import crystalpalace.util.CrystalUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Hooks {
    protected ExportObject object;
    protected Map external = new HashMap();
    protected Map local = new HashMap();
    protected Map notouch = new HashMap();
    protected Map optout = new HashMap();
    protected Set protect = new HashSet();
    protected Map resolve = new HashMap();
    protected int HookIndex = 0;

    public boolean isPreserved(String target, String func) {
        if (!this.notouch.containsKey(target)) {
            return false;
        }
        return this.getSet(this.notouch, target).contains(func);
    }

    public boolean isOptOut(String target, String hook) {
        if (!this.optout.containsKey(target)) {
            return false;
        }
        return this.getSet(this.optout, target).contains(hook);
    }

    public void attach(String target, String wrapper) {
        this.object.check(wrapper);
        new ModFunc(target);
        this.getChain(this.external, target).add(new Hook(target, wrapper, this.HookIndex++));
    }

    public void redirect(String target, String wrapper) {
        this.object.check(wrapper);
        this.getChain(this.local, target).add(new Hook(target, wrapper, this.HookIndex++));
    }

    public void preserve(String target, String funcs) {
        HashSet preserveme = this.getSet(this.notouch, target);
        for (String next : CrystalUtils.toSet(funcs)) {
            this.object.check(next);
            preserveme.add(next);
        }
    }

    public void optout(String target, String hooks) {
        HashSet stayaway = this.getSet(this.optout, target);
        this.object.check(target);
        for (String next : CrystalUtils.toSet(hooks)) {
            this.object.check(next);
            stayaway.add(next);
        }
    }

    public void protect(String funcs) {
        for (String next : CrystalUtils.toSet(funcs)) {
            this.protect.add(next);
        }
    }

    public String getHook(String context, String target) {
        if (this.external.containsKey(target)) {
            return this.getChain(this.external, target).resolve(context);
        }
        return null;
    }

    public String getLocalHook(String context, String target) {
        if (this.local.containsKey(target)) {
            return this.getChain(this.local, target).resolve(context);
        }
        return null;
    }

    public boolean hasHooks() {
        return this.external.size() > 0;
    }

    public boolean hasLocalHooks() {
        return this.local.size() > 0;
    }

    protected HookChain getChain(Map map, String key) {
        if (!map.containsKey(key)) {
            map.put(key, new HookChain(key));
        }
        return (HookChain)map.get(key);
    }

    protected HashSet getSet(Map map, String key) {
        if (!map.containsKey(key)) {
            map.put(key, new HashSet());
        }
        return (HashSet)map.get(key);
    }

    public Hooks(ExportObject object) {
        this.object = object;
        if (object.object.getMachine().equals("x64")) {
            this.protect.add("dprintf");
        } else {
            this.protect.add("_dprintf");
        }
    }

    public void addResolveHook(String target) {
        ResolveHook rhook = new ResolveHook(target, null);
        this.resolve.put(rhook.getFunction(), rhook);
    }

    public void addResolveHook(String target, String wrapper) {
        this.object.check(wrapper);
        ResolveHook rhook = new ResolveHook(target, wrapper);
        this.resolve.put(rhook.getFunction(), rhook);
    }

    public List getResolveHooks() {
        LinkedList result = new LinkedList();
        result.addAll(this.resolve.values());
        Collections.shuffle(result);
        return result;
    }

    public void filterResolveHooks(byte[] content) {
        Set imps = Imports.getImports(content).getStrings();
        Iterator i = this.resolve.values().iterator();
        while (i.hasNext()) {
            ResolveHook next = (ResolveHook)i.next();
            if (imps.contains(next.getTarget())) continue;
            i.remove();
        }
    }

    public static class ResolveHook {
        protected String wrapper;
        protected ModFunc modfunc;

        public ResolveHook(String target, String wrapper) {
            this.wrapper = wrapper;
            this.modfunc = new ModFunc(target);
        }

        public int getFunctionHash() {
            return CrystalUtils.ror13(this.getFunction().getBytes());
        }

        public String getFunction() {
            return this.modfunc.getFunction();
        }

        public String getTarget() {
            return this.modfunc.toString();
        }

        public String getWrapper() {
            return this.wrapper;
        }

        public boolean isSelf() {
            return this.wrapper == null;
        }
    }

    protected static class ModFunc {
        public String module;
        public String function;

        public ModFunc(String target) {
            String[] parse = target.split("\\$");
            if (parse.length == 1) {
                throw new RuntimeException(target + " is not in MODULE$Function format");
            }
            this.module = parse[0];
            this.function = parse[1];
        }

        public String getFunction() {
            return this.function;
        }

        public String getModule() {
            return this.module;
        }

        public String toString() {
            return this.module.toUpperCase() + "$" + this.function;
        }
    }

    public static class Hook {
        protected String target;
        protected String wrapper;
        protected int index;

        public Hook(String target, String wrapper, int index) {
            this.target = target;
            this.wrapper = wrapper;
            this.index = index;
        }

        public String getTarget() {
            return this.target;
        }

        public String getWrapper() {
            return this.wrapper;
        }

        public int getDeclaredIndex() {
            return this.index;
        }

        public String toString() {
            return "Hook " + this.target + " -> " + this.wrapper;
        }
    }

    public class HookChain {
        protected String target;
        protected Map hooks = new LinkedHashMap();
        protected Map cache = new HashMap();

        public HookChain(String target) {
            this.target = target;
        }

        public void add(Hook hook) {
            if (this.hooks.containsKey(hook.getWrapper())) {
                throw new RuntimeException(hook + " already declared. Order matters. Please remove duplicate.");
            }
            this.hooks.put(hook.getWrapper(), hook);
        }

        public boolean eval(String context, Hook cand) {
            if (cand.getWrapper().equals(context)) {
                return false;
            }
            if (Hooks.this.isOptOut(context, cand.getWrapper())) {
                return false;
            }
            Hook temp = (Hook)this.hooks.get(context);
            if (temp != null && temp.getDeclaredIndex() > cand.getDeclaredIndex()) {
                return false;
            }
            String next = this.resolve(cand.getWrapper());
            while (next != null) {
                if (Hooks.this.isOptOut(context, next)) {
                    return false;
                }
                next = this.resolve(next);
            }
            return true;
        }

        public String resolve(String context) {
            if (this.cache.containsKey(context)) {
                return (String)this.cache.get(context);
            }
            String value = this._resolve(context);
            this.cache.put(context, value);
            return value;
        }

        public String _resolve(String context) {
            if (Hooks.this.protect.contains(context)) {
                return null;
            }
            if (Hooks.this.isPreserved(this.target, context)) {
                return null;
            }
            if (this.target.equals(context)) {
                return null;
            }
            for (Hook cand : this.hooks.values()) {
                if (!this.eval(context, cand)) continue;
                return cand.getWrapper();
            }
            return null;
        }
    }
}

