/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.util.Concat;
import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Logger;
import crystalpalace.util.Packer;

public class FormatPICO {
    protected Concat program = new Concat();
    public static final int PICO_INST_COMPLETE = 0;
    public static final int PICO_INST_PATCH = 1;
    public static final int PICO_INST_COPY = 2;
    public static final int PICO_INST_LL = 3;
    public static final int PICO_INST_GPA = 4;
    public static final int PICO_INST_PATCH_DIFF = 5;
    public static final int PICO_INST_PATCH_FUNC = 6;
    public static final int PICO_INST_EXPORT = 7;
    public static final int PICO_OPT_NONE = 0;
    public static final int PICO_PATCH_TEXT_TEXT = 0;
    public static final int PICO_PATCH_TEXT_BASE = 1;
    public static final int PICO_PATCH_BASE_TEXT = 2;
    public static final int PICO_PATCH_BASE_BASE = 3;
    public static final int PICO_PATCHF_FUNC = 0;
    public static final int PICO_CONTEXT_CODE = 5;
    public static final int PICO_CONTEXT_DATA = 6;

    private void p(String x) {
        Logger.println(x);
    }

    protected byte[] header(int type, int option, byte[] data) {
        Packer packer = new Packer();
        packer.little();
        packer.addByte(type);
        packer.addByte(option);
        packer.addShort((short)(4 + data.length));
        return packer.getBytes();
    }

    protected void push(int type, int option, byte[] data) {
        this.program.add(this.header(type, option, data));
        this.program.add(data);
    }

    public void Complete() {
        this.p("COMPLETE");
        this.push(0, 0, new byte[0]);
    }

    public void CopyCode(int src, int dst, int length) {
        this.Copy(5, src, dst, length);
    }

    public void CopyData(int src, int dst, int length) {
        this.Copy(6, src, dst, length);
    }

    public void Copy(int ctx, int src, int dst, int length) {
        Packer packer = new Packer();
        packer.little();
        packer.addInt(src);
        packer.addInt(dst);
        packer.addInt(length);
        this.p("COPY " + (ctx == 0 ? "CODE" : "DATA") + " src: " + src + ", dst: " + dst + ", len: " + length);
        this.push(2, ctx, packer.getBytes());
    }

    public void Export(int tag, int offset) {
        Packer packer = new Packer();
        packer.little();
        packer.addInt(tag);
        packer.addInt(offset);
        this.p("EXPORT tag " + tag + " at offset " + offset);
        this.push(7, 0, packer.getBytes());
    }

    public void Patch(int type, int opt, int dst) {
        Packer packer = new Packer();
        packer.little();
        packer.addInt(dst);
        this.push(type, opt, packer.getBytes());
    }

    public void PatchTextText(int dst) {
        this.p("PATCH (TEXT) TEXT " + dst + " " + CrystalUtils.toHex(dst));
        this.Patch(1, 0, dst);
    }

    public void PatchTextBase(int dst) {
        this.p("PATCH (TEXT) BASE " + dst + " " + CrystalUtils.toHex(dst));
        this.Patch(1, 1, dst);
    }

    public void PatchBaseText(int dst) {
        this.p("PATCH (BASE) TEXT " + dst + " " + CrystalUtils.toHex(dst));
        this.Patch(1, 2, dst);
    }

    public void PatchBaseBase(int dst) {
        this.p("PATCH (BASE) BASE " + dst + " " + CrystalUtils.toHex(dst));
        this.Patch(1, 3, dst);
    }

    public void PatchBaseDiff(int dst) {
        this.p("PATCH BASE DIFF " + dst + " " + CrystalUtils.toHex(dst));
        this.Patch(5, 0, dst);
    }

    public void PatchFunction(int dst) {
        this.p("PATCH FUNC " + dst + " " + CrystalUtils.toHex(dst) + " (address)");
        this.Patch(6, 0, dst);
    }

    public void PatchImport(int dst, int index) {
        this.p("PATCH FUNC " + dst + " " + CrystalUtils.toHex(dst) + " index " + index);
        this.Patch(6, index + 1, dst);
    }

    protected byte[] toBytesZ(String val) {
        try {
            val = val + '\u0000';
            return val.getBytes("UTF-8");
        }
        catch (Exception ioex) {
            CrystalUtils.handleException(ioex);
            return new byte[0];
        }
    }

    public void GetProcAddress(String func) {
        this.p("GETPROCADDRESS " + func);
        this.push(4, 0, this.toBytesZ(func));
    }

    public void LoadLibrary(String mod) {
        this.p("LOADLIBRARY " + mod);
        this.push(3, 0, this.toBytesZ(mod));
    }

    public byte[] getBytes() {
        return this.program.get();
    }
}

