/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.export;

import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import crystalpalace.export.Locations;
import crystalpalace.export.ProgramCOFF;
import crystalpalace.util.Concat;
import crystalpalace.util.CrystalUtils;
import crystalpalace.util.Packer;
import java.util.HashMap;
import java.util.List;

public class FormatCOFF {
    protected Packer packer = new Packer();
    protected Locations locs = new Locations();

    public FormatCOFF() {
        this.packer.little();
    }

    public void report(Object key, String subkey) {
        this.report(key, subkey, this.packer.size());
    }

    public void report(Object key, String subkey, int value) {
        this.locs.put(key, subkey, value);
    }

    public void fixLater(Object key, String subkey) {
        this.locs.fixLater(key, subkey, this.packer.size());
        this.packer.addInt(0);
    }

    public void putName(String name) {
        this.packer.addInt(0);
        this.fixLater("stringTable", name);
    }

    public void putSectionName(String name) {
        if (name.length() > 7) {
            throw new RuntimeException("Section name " + name + " is >7 chars. Not supported.");
        }
        byte[] temp = CrystalUtils.toUTF8Z(name);
        this.packer.addBytes(temp);
        this.packer.pad(8 - temp.length);
    }

    public static int toMachine(String arch) {
        if ("x86".equals(arch)) {
            return 332;
        }
        if ("x64".equals(arch)) {
            return 34404;
        }
        if ("arm64".equals(arch)) {
            return 43620;
        }
        throw new RuntimeException("Invalid arch " + arch);
    }

    public void header(String arch, int sectionCount) {
        this.packer.addUShort(FormatCOFF.toMachine(arch));
        this.packer.addUShort(sectionCount);
        this.packer.addInt(0);
        this.fixLater("", "PointerToSymbolTable");
        this.fixLater("", "NumberOfSymbols");
        this.packer.addUShort(0);
        this.packer.addUShort(4);
    }

    public void relocation(Relocation reloc) {
        this.packer.addInt((int)reloc.getVirtualAddress());
        this.fixLater(reloc, "SymbolTableIndex");
        this.packer.addUShort(reloc.getType());
    }

    public void sectionHeader(Section sect) {
        byte[] rawdata = sect.getRawData();
        List relocs = sect.getRelocations();
        this.putSectionName(sect.getName());
        this.packer.addInt(0);
        this.packer.addInt(0);
        this.packer.addInt(rawdata.length);
        if (sect.isUninitialized()) {
            this.packer.addInt(0);
            this.packer.addInt(0);
            if (relocs.size() > 0) {
                throw new RuntimeException("Section " + sect.getName() + " is not init (like .bss); but has relocations? HOW?!?");
            }
        } else {
            this.fixLater(sect, "PointerToRawData");
            this.fixLater(sect, "PointerToRelocations");
        }
        this.packer.addInt(0);
        this.packer.addUShort(relocs.size());
        this.packer.addUShort(0);
        this.packer.addInt((int)sect.getCharacteristics());
    }

    public void sectionData(Section sect) {
        String name = sect.getName();
        byte[] rawdata = sect.getRawData();
        List relocs = sect.getRelocations();
        if (sect.isUninitialized()) {
            return;
        }
        this.report(sect, "PointerToRelocations");
        for (Relocation reloc : relocs) {
            this.relocation(reloc);
        }
        this.report(sect, "PointerToRawData");
        this.packer.addBytes(rawdata);
    }

    public void symbol(String name, long value, int sectionNumber, int type, int sclass) {
        this.putName(name);
        this.packer.addInt((int)value);
        this.packer.addUShort(sectionNumber);
        this.packer.addUShort(type);
        this.packer.addByte((byte)sclass);
        this.packer.addByte(0);
    }

    public void symbolTable(ProgramCOFF exe) {
        int count = 0;
        HashMap<String, Integer> offs = new HashMap<String, Integer>();
        this.report("", "PointerToSymbolTable");
        for (Section _sect : exe.getSections()) {
            this.symbol(_sect.getName(), 0L, exe.getSectionNumber(_sect), 0, 3);
            offs.put(_sect.getName(), count);
            ++count;
        }
        for (Symbol _symbol : exe.getSymbols()) {
            this.symbol(_symbol.getName(), _symbol.getValue(), exe.getSectionNumber(_symbol.getSection()), _symbol.getType(), 2);
            offs.put(_symbol.getName(), count);
            ++count;
        }
        for (Relocation _reloc : exe.getRelocations()) {
            if (offs.containsKey(_reloc.getSymbolName())) {
                this.report(_reloc, "SymbolTableIndex", (Integer)offs.get(_reloc.getSymbolName()));
                continue;
            }
            this.report(_reloc, "SymbolTableIndex", count);
            this.symbol(_reloc.getSymbolName(), 0L, 0, 0, 2);
            offs.put(_reloc.getSymbolName(), count);
            ++count;
        }
        this.report("", "NumberOfSymbols", count);
    }

    public void stringTable(ProgramCOFF exe) {
        Concat strings = new Concat();
        for (String temp : exe.getStrings()) {
            this.report("stringTable", temp, strings.length() + 4);
            strings.add(CrystalUtils.toUTF8Z(temp));
        }
        this.packer.addInt(strings.length() + 4);
        this.packer.addBytes(strings.get());
    }

    public byte[] getBytes() {
        byte[] temp = this.packer.getBytes();
        this.locs.patch(temp);
        return temp;
    }
}

