/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.coff;

import crystalpalace.coff.COFFObject;
import crystalpalace.coff.COFFWalker;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.SectionFlags;
import crystalpalace.coff.Symbol;
import crystalpalace.util.Printer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Section {
    protected COFFObject object;
    protected String Name;
    protected byte[] RawData;
    protected long Characteristics;
    protected List relocations = new LinkedList();

    public Section() {
    }

    public Section(COFFObject obj, String name) {
        this.object = obj;
        this.Name = name;
        this.Characteristics = SectionFlags.getFlags(name);
    }

    public Section(COFFObject obj, COFFWalker.Section sect) {
        this.object = obj;
        this.Name = sect.getName();
        this.RawData = sect.getRawData();
        this.Characteristics = sect.getCharacteristics();
    }

    public COFFObject getObject() {
        return this.object;
    }

    public String getGroupName() {
        String name = this.getName();
        if (name.indexOf(36) != -1) {
            name = name.substring(0, name.indexOf(36));
        }
        return name;
    }

    public String getName() {
        return this.Name;
    }

    public void setData(byte[] rawd) {
        this.RawData = rawd;
    }

    public byte[] getData() {
        int rawlen = this.RawData.length;
        int padlen = 4096 - rawlen % 4096;
        byte[] temp = new byte[rawlen + padlen];
        for (int x = 0; x < this.RawData.length; ++x) {
            temp[x] = this.RawData[x];
        }
        return temp;
    }

    public boolean isUninitialized() {
        return SectionFlags.isUninitialized(this.Characteristics);
    }

    public boolean isExecutable() {
        return SectionFlags.isExecute(this.Characteristics);
    }

    public boolean isCommonData() {
        return SectionFlags.isCommonData(this.Characteristics);
    }

    public long getCharacteristics() {
        return this.Characteristics;
    }

    public int getPadLength() {
        return 4096 - this.RawData.length % 4096;
    }

    public byte[] getRawData() {
        return this.RawData;
    }

    public void patch(int offset, byte[] patch) {
        for (int x = 0; x < patch.length; ++x) {
            this.RawData[x + offset] = patch[x];
        }
    }

    public byte[] fetch(int offset, int length) {
        byte[] temp = new byte[length];
        for (int x = 0; x < temp.length; ++x) {
            temp[x] = this.RawData[x + offset];
        }
        return temp;
    }

    public List getRelocations() {
        return this.relocations;
    }

    public boolean hasRelocations() {
        return this.getRelocations().size() > 0;
    }

    public List getSymbols() {
        LinkedList<Symbol> symbols = new LinkedList<Symbol>();
        for (Symbol next : this.getObject().getSymbols().values()) {
            if (next.getSection() != this || next.isSectionName()) continue;
            symbols.add(next);
        }
        Collections.sort(symbols);
        return symbols;
    }

    public void setRelocations(List r) {
        this.relocations = r;
    }

    public String toString() {
        return "Section " + this.getName() + ", " + this.RawData.length + "b, " + SectionFlags.toString(this.getCharacteristics());
    }

    public void toString(int idx, Printer printer) {
        printer.push("Section " + idx);
        printer.print("Name", this.getName());
        printer.print("SizeOfRawData", this.RawData.length);
        printer.print("Characteristics", SectionFlags.toString(this.getCharacteristics()));
        Iterator i = this.getSymbols().iterator();
        int x = 0;
        while (i.hasNext()) {
            Symbol next = (Symbol)i.next();
            next.toString(x, printer);
            ++x;
        }
        Iterator j = this.getRelocations().iterator();
        int x2 = 0;
        while (j.hasNext()) {
            Relocation next = (Relocation)j.next();
            next.toString(x2, printer);
            ++x2;
        }
        printer.pop();
    }
}

