/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.coff;

import crystalpalace.coff.Relocation;
import crystalpalace.coff.Section;
import crystalpalace.coff.Symbol;
import crystalpalace.util.Printer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class COFFObject {
    protected String Machine;
    protected Map sections = new LinkedHashMap();
    protected Map symbols = new LinkedHashMap();

    public COFFObject(String Machine) {
        this.Machine = Machine;
    }

    public void removeSymbols(Set removeme) {
        Iterator i = this.symbols.keySet().iterator();
        while (i.hasNext()) {
            String next = (String)i.next();
            if (!removeme.contains(next)) continue;
            i.remove();
        }
    }

    public void remapSymbol(String oldsymb, String newsymb) {
        if (this.getSymbol(oldsymb) == null) {
            return;
        }
        if (this.getSymbol(newsymb) == null) {
            Symbol temp = this.getSymbol(oldsymb);
            temp.Name = newsymb;
            this.symbols.put(newsymb, temp);
        } else {
            Symbol olds = this.getSymbol(oldsymb);
            Symbol news = this.getSymbol(newsymb);
            if (news.section == null && news.Type == olds.Type && news.Value == 0L && news.StorageClass == 2) {
                olds.Name = newsymb;
                this.symbols.put(newsymb, olds);
            } else {
                if (olds.section != news.section) {
                    throw new RuntimeException("Can't remap " + oldsymb + " to existing " + newsymb + " (Section mismatch)");
                }
                if (olds.Type != news.Type) {
                    throw new RuntimeException("Can't remap " + oldsymb + " to existing " + newsymb + " (Type mismatch)");
                }
                if (olds.StorageClass != news.StorageClass) {
                    throw new RuntimeException("Can't remap " + oldsymb + " to existing " + newsymb + " (StorageClass mismatch)");
                }
                if (olds.Value != news.Value) {
                    throw new RuntimeException("Can't remap " + oldsymb + " to existing " + newsymb + " (Value mismatch)");
                }
            }
        }
        Iterator i = this.getSections().values().iterator();
        int x = 0;
        while (i.hasNext()) {
            Section next = (Section)i.next();
            for (Relocation reloc : next.getRelocations()) {
                if (!oldsymb.equals(reloc.getSymbolName())) continue;
                reloc.SymbolName = newsymb;
            }
            ++x;
        }
        this.symbols.remove(oldsymb);
    }

    public Symbol getSymbol(String name) {
        return (Symbol)this.symbols.get(name);
    }

    public Symbol checkPatch(String name, byte[] data) {
        Symbol temp = this.getSymbol(name);
        if (temp == null) {
            throw new RuntimeException("No symbol '" + name + "'");
        }
        Section sect = temp.getSection();
        if (sect.isUninitialized()) {
            throw new RuntimeException("Can't patch symbol " + name + " in uninitialized " + sect.getName() + " section");
        }
        long est = temp.estimateSize();
        if (est == 4L || est == 8L) {
            if (est != (long)data.length) {
                throw new RuntimeException("Symbol " + name + " (est.) size " + est + "b differs from patch " + data.length + "b size");
            }
        } else if ((long)data.length > est) {
            throw new RuntimeException("Symbol " + name + " (est.) size " + est + "b is LESS than patch " + data.length + "b size");
        }
        return temp;
    }

    public void patch(String name, byte[] data) {
        Symbol temp = this.checkPatch(name, data);
        temp.getSection().patch((int)temp.getValue(), data);
    }

    public String getMachine() {
        return this.Machine;
    }

    public boolean isIntel() {
        return "x64".equals(this.getMachine()) || "x86".equals(this.getMachine());
    }

    public boolean x86() {
        return "x86".equals(this.getMachine());
    }

    public boolean x64() {
        return "x64".equals(this.getMachine());
    }

    public int getBits() {
        if ("x86".equals(this.getMachine())) {
            return 32;
        }
        if ("x64".equals(this.getMachine())) {
            return 64;
        }
        throw new RuntimeException("Can't get bits for arch '" + this.getMachine() + "'");
    }

    public Map getSections() {
        return this.sections;
    }

    public Map getSymbols() {
        return this.symbols;
    }

    public Section getSection(String name) {
        return (Section)this.sections.get(name);
    }

    public void toString(Printer printer) {
        printer.print("Machine", this.getMachine());
        Iterator i = this.getSymbols().values().iterator();
        int x = 0;
        while (i.hasNext()) {
            Symbol symb = (Symbol)i.next();
            symb.toString(x, printer);
            ++x;
        }
        Iterator j = this.getSections().values().iterator();
        int x2 = 0;
        while (j.hasNext()) {
            Section sect = (Section)j.next();
            sect.toString(x2, printer);
            ++x2;
        }
    }

    public String toString() {
        Printer printer = new Printer();
        this.toString(printer);
        return printer.toString();
    }
}

