/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.mutate;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.FilterCode;
import crystalpalace.btf.Rebuilder;
import crystalpalace.btf.lttl.SavedRegContext;
import crystalpalace.btf.pass.RegConvert;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RegDance
implements FilterCode {
    protected Map remap = new HashMap();

    public boolean isSwappable(int x) {
        return this.remap.containsKey(SavedRegContext.toBaseReg(x));
    }

    public int getSwapRegister(int x) {
        AsmRegister64 reg = (AsmRegister64)this.remap.get(SavedRegContext.toBaseReg(x));
        switch (SavedRegContext.toSize(x)) {
            case 64: {
                return reg.get().get();
            }
            case 32: {
                return RegConvert.toReg32(reg).get().get();
            }
            case 16: {
                return RegConvert.toReg16(reg).get().get();
            }
            case 8: {
                return RegConvert.toReg8(reg).get().get();
            }
        }
        throw new RuntimeException("invalid size for " + x);
    }

    protected String beforeAfter(int x) {
        return CodeUtils.getRegString(x) + " -> " + CodeUtils.getRegString(this.getSwapRegister(x));
    }

    @Override
    public List filterCode(Rebuilder builder, String func, List instructions) {
        SavedRegContext stackInfo = new SavedRegContext(builder, func, instructions);
        this.remap = new HashMap();
        if (!stackInfo.isSane()) {
            return instructions;
        }
        LinkedList swappables = new LinkedList(stackInfo.getSwappableRegisters());
        Collections.shuffle(swappables);
        Iterator orig = stackInfo.getSwappableRegisters().iterator();
        Iterator random = swappables.iterator();
        while (orig.hasNext() && random.hasNext()) {
            this.remap.put(orig.next(), random.next());
        }
        for (Instruction next : instructions) {
            if (stackInfo.isBookend(next)) continue;
            for (int x = 0; x < next.getOpCount(); ++x) {
                if (next.getOpKind(x) != 0 || !this.isSwappable(next.getOpRegister(x))) continue;
                next.setOpRegister(x, this.getSwapRegister(next.getOpRegister(x)));
            }
            if (this.isSwappable(next.getMemoryBase())) {
                next.setMemoryBase(this.getSwapRegister(next.getMemoryBase()));
            }
            if (!this.isSwappable(next.getMemoryIndex())) continue;
            next.setMemoryIndex(this.getSwapRegister(next.getMemoryIndex()));
        }
        return instructions;
    }
}

