/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.mutate;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.Register;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.Code;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.pass.BaseModify;
import crystalpalace.btf.pass.RegConvert;

public class Mutator
extends BaseModify {
    @Override
    public void setupVerbs() {
        this.verbs.add(new Cmp());
        this.verbs.add(new MovImmReg32());
        this.verbs.add(new MovImmReg64());
        this.verbs.add(new MovImmMem32());
        this.verbs.add(new PushImm32());
    }

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (step.hasRelocation()) {
            return false;
        }
        return !step.isDangerous();
    }

    public Mutator(Code code) {
        super(code);
    }

    protected void _buildConstant64(CodeAssembler program, AsmRegister64 reg, long constant) {
        long part1 = this.nextLong();
        AsmRegister64 tmp = this.getRandReg64(reg);
        program.push(tmp);
        program.mov(tmp, part1);
        program.mov(reg, constant - part1);
        program.add(reg, tmp);
        program.pop(tmp);
    }

    protected void _buildConstant(CodeAssembler program, AsmRegister32 reg, int constant) {
        if (constant == 0) {
            this._zeroReg32(program, reg);
            return;
        }
        int part1 = this.nextInt(Math.abs(constant));
        switch (this.nextInt(4)) {
            case 0: {
                this._zeroReg32(program, reg);
                program.add(reg, part1);
                program.add(reg, constant - part1);
                break;
            }
            case 1: {
                program.mov(reg, part1);
                program.add(reg, constant - part1);
                break;
            }
            case 2: {
                this._zeroReg32(program, reg);
                program.or(reg, part1);
                program.add(reg, constant - part1);
                break;
            }
            case 3: {
                this._buildConstant(program, reg, part1);
                program.add(reg, constant - part1);
            }
        }
    }

    protected void _zeroReg32(CodeAssembler program, AsmRegister32 reg) {
        switch (this.nextInt(4)) {
            case 0: {
                program.xor(reg, reg);
                break;
            }
            case 1: {
                program.and(reg, 0);
                break;
            }
            case 2: {
                program.mov(reg, 0);
                break;
            }
            case 3: {
                program.sub(reg, reg);
            }
        }
    }

    private class Cmp
    implements BaseModify.ModifyVerb {
        private Cmp() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return ("CMP EAX, imm32".equals(istr) || "CMP r/m32, imm32".equals(istr)) && Register.isGPR32(next.getOp0Register());
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 dst = new AsmRegister32(new ICRegister(next.getOp0Register()));
            AsmRegister32 tmp = Mutator.this.getRandReg32(dst);
            if (Mutator.this.object.x64()) {
                AsmRegister64 tmp64 = RegConvert.toReg64(tmp);
                program.push(tmp64);
                Mutator.this._buildConstant(program, tmp, next.getImmediate32());
                program.cmp(dst, tmp);
                program.pop(tmp64);
            } else {
                program.push(tmp);
                Mutator.this._buildConstant(program, tmp, next.getImmediate32());
                program.cmp(dst, tmp);
                program.pop(tmp);
            }
        }
    }

    private class MovImmMem32
    implements BaseModify.ModifyVerb {
        private MovImmMem32() {
        }

        public boolean isDesiredReg(Instruction next) {
            return next.getMemoryBase() == 58 || next.getMemoryBase() == 57 || next.getMemoryBase() == 42 || next.getMemoryBase() == 41;
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m32, imm32".equals(istr) && this.isDesiredReg(next) && next.getMemoryIndex() == 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            if ("x64".equals(Mutator.this.object.getMachine())) {
                AsmRegister64 reg64 = Mutator.this.getRandReg64();
                AsmRegister32 reg32 = Mutator.this.toReg32(reg64);
                AsmMemoryOperand dst = Mutator.this.getMemOperand(next);
                if (next.getMemoryBase() == 57) {
                    dst = dst.add(8L);
                }
                program.push(reg64);
                Mutator.this._buildConstant(program, reg32, next.getImmediate32());
                program.mov(dst, reg32);
                program.pop(reg64);
            } else if ("x86".equals(Mutator.this.object.getMachine())) {
                AsmRegister32 reg32 = Mutator.this.getRandReg32();
                AsmMemoryOperand dst = Mutator.this.getMemOperand(next);
                if (next.getMemoryBase() == 41) {
                    dst = dst.add(4L);
                }
                program.push(reg32);
                Mutator.this._buildConstant(program, reg32, next.getImmediate32());
                program.mov(dst, reg32);
                program.pop(reg32);
            }
        }
    }

    private class MovImmReg64
    implements BaseModify.ModifyVerb {
        private MovImmReg64() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r64, imm64".equals(istr) && next.getImmediate64() != 0L;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister64 reg = new AsmRegister64(new ICRegister(next.getOp0Register()));
            Mutator.this._buildConstant64(program, reg, next.getImmediate64());
        }
    }

    private class MovImmReg32
    implements BaseModify.ModifyVerb {
        private MovImmReg32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, imm32".equals(istr) && next.getImmediate32() != 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 reg = new AsmRegister32(new ICRegister(next.getOp0Register()));
            Mutator.this._buildConstant(program, reg, next.getImmediate32());
        }
    }

    private class PushImm32
    implements BaseModify.ModifyVerb {
        private PushImm32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "PUSH imm32".equals(istr) && next.getImmediate32() != 0 && "x86".equals(Mutator.this.object.getMachine());
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 reg = Mutator.this.getRandReg32();
            program.push(reg);
            Mutator.this._buildConstant(program, reg, next.getImmediate32());
            program.xchg(Mutator.this.getStackPtr(), reg);
        }
    }
}

