/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.mutate;

import com.github.icedland.iced.x86.Instruction;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.pass.CallWalk;
import crystalpalace.export.ExportInfo;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class LinkTimeOptimizer
extends CallWalk {
    public LinkTimeOptimizer(Code code) {
        super(code);
    }

    public void walk(String symbol) {
        if ("x64".equals(this.object.getMachine())) {
            this.walk_x64(symbol);
        } else {
            this.walk_x86(symbol);
        }
    }

    public Map apply(ExportInfo exports, Map _funcs) {
        this.funcs = _funcs;
        if ("x64".equals(this.object.getMachine())) {
            if (this.funcs.containsKey("go")) {
                this.walk_x64("go");
            }
        } else if (this.funcs.containsKey("_go")) {
            this.walk_x86("_go");
        }
        Iterator z = exports.iterator();
        while (z.hasNext()) {
            Map.Entry entry = (Map.Entry)z.next();
            this.walk((String)entry.getKey());
        }
        if (this.touched.size() == 0) {
            throw new RuntimeException("+optimize requires go() function as entrypoint or 1+ exported functions.");
        }
        HashSet<String> removeme = new HashSet<String>();
        Iterator i = this.funcs.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!this.object.getSymbol(entry.getKey().toString()).isFunction() || this.touched.contains(entry.getKey().toString())) continue;
            i.remove();
            removeme.add(entry.getKey().toString());
        }
        this.object.removeSymbols(removeme);
        for (LinkedList instrs : this.funcs.values()) {
            Instruction next;
            Iterator k = instrs.descendingIterator();
            while (k.hasNext() && (CodeUtils.is(next = (Instruction)k.next(), "NOP") || CodeUtils.is(next, "INT3"))) {
                k.remove();
            }
        }
        return this.funcs;
    }
}

