/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.hook;

import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.Code;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.pass.BaseModify;
import crystalpalace.export.Exports;
import crystalpalace.spec.TagStore;

public class ResolveTags
extends BaseModify {
    protected TagStore tags;
    protected TagStore.Tag tag = null;

    @Override
    public void setupVerbs() {
        this.verbs.add(new Call32());
    }

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (!step.hasRelocation()) {
            return false;
        }
        String symbol = step.getRelocation().getSymbolName();
        this.tag = this.tags.getSymbolTag(symbol);
        if (this.tag != null) {
            return true;
        }
        if (symbol.startsWith("__tag_") || symbol.startsWith("___tag_")) {
            throw new RuntimeException("exporfunc for " + symbol + " not found at " + step.getInstructionString());
        }
        return false;
    }

    @Override
    public void noMatch(CodeAssembler program, RebuildStep step, Instruction next) {
        throw new RuntimeException("Can't expand linker intrinsic " + this.tag.getSymbol() + " for " + step.getInstructionString());
    }

    public ResolveTags(Code code, Exports exports) {
        super(code);
        this.tags = exports.getTags();
    }

    private class Call32
    implements BaseModify.ModifyVerb {
        private Call32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "CALL rel32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            if (ResolveTags.this.x64) {
                AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
                program.mov(rax, (long)ResolveTags.this.tag.getTag());
            } else {
                AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
                program.mov(eax, ResolveTags.this.tag.getTag());
            }
            step.resolve();
        }
    }
}

