/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.hook;

import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegisters;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.asm.CodeLabel;
import crystalpalace.btf.Code;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.pass.BaseModify;
import crystalpalace.coff.Symbol;
import crystalpalace.export.Hooks;

public class ResolveHooks
extends BaseModify {
    protected Hooks hooks = null;

    @Override
    public void setupVerbs() {
        this.verbs.add(new Call32());
    }

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (!step.hasRelocation()) {
            return false;
        }
        if (this.x64) {
            return "__resolve_hook".equals(step.getRelocation().getSymbolName());
        }
        return "___resolve_hook".equals(step.getRelocation().getSymbolName());
    }

    @Override
    public void noMatch(CodeAssembler program, RebuildStep step, Instruction next) {
        throw new RuntimeException("Can't expand linker intrinsic __resolve_hook() for " + step.getInstructionString());
    }

    public ResolveHooks(Code code, Hooks hooks) {
        super(code);
        this.hooks = hooks;
    }

    public void generateResolver_x86(CodeAssembler program, RebuildStep step) {
        AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
        AsmRegister32 esp = new AsmRegister32(ICRegisters.esp);
        CodeLabel done = program.createLabel();
        program.mov(eax, AsmRegisters.mem_ptr(new AsmRegister32(ICRegisters.esp), 0L));
        for (Hooks.ResolveHook reshook : this.hooks.getResolveHooks()) {
            Symbol wrapper = null;
            String hookfunc = null;
            hookfunc = reshook.isSelf() ? this.hooks.getHook(step.getFunction(), reshook.getTarget()) : reshook.getWrapper();
            wrapper = this.object.getSymbol(hookfunc);
            if (wrapper == null) continue;
            program.cmp(eax, reshook.getFunctionHash());
            program.jne(program.f());
            step.createRelocationFor(program, wrapper, 1);
            program.mov(eax, 0);
            program.jmp(done);
            program.anonymousLabel();
        }
        program.xor(eax, eax);
        program.label(done);
    }

    public void generateResolver_x64(CodeAssembler program, RebuildStep step) {
        AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
        AsmRegister32 ecx = new AsmRegister32(ICRegisters.ecx);
        CodeLabel done = program.createLabel();
        for (Hooks.ResolveHook reshook : this.hooks.getResolveHooks()) {
            Symbol wrapper = null;
            String hookfunc = null;
            hookfunc = reshook.isSelf() ? this.hooks.getHook(step.getFunction(), reshook.getTarget()) : reshook.getWrapper();
            wrapper = this.object.getSymbol(hookfunc);
            if (wrapper == null) continue;
            program.cmp(ecx, reshook.getFunctionHash());
            program.jne(program.f());
            program.lea(rax, AsmRegisters.mem_ptr(step.getLabel(hookfunc)));
            program.jmp(done);
            program.anonymousLabel();
        }
        program.xor(rax, rax);
        program.label(done);
    }

    private class Call32
    implements BaseModify.ModifyVerb {
        private Call32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "CALL rel32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            if (ResolveHooks.this.x64) {
                ResolveHooks.this.generateResolver_x64(program, step);
            } else {
                ResolveHooks.this.generateResolver_x86(program, step);
            }
            step.resolve();
        }
    }
}

