/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.hook;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.asm.CodeLabel;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeInfo;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.ResolveLabel;
import crystalpalace.btf.pass.BaseModify;
import crystalpalace.coff.Symbol;
import crystalpalace.export.Hooks;

public class Redirect
extends BaseModify
implements ResolveLabel {
    protected Hooks hooks = null;
    protected String hookfunc = null;

    public Redirect(Code code, Hooks hooks) {
        super(code);
        this.hooks = hooks;
    }

    @Override
    public CodeLabel getCodeLabel(RebuildStep step, String symbol) {
        this.hookfunc = this.hooks.getLocalHook(step.getFunction(), symbol);
        if (this.hookfunc != null) {
            return step.getLabel(this.hookfunc);
        }
        return step.getLabel(symbol);
    }

    @Override
    public void setupVerbs() {
        if (!this.x64) {
            this.verbs.add(new LoadAddress());
        }
    }

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (!step.hasRelocation()) {
            return false;
        }
        if (!".text".equals(step.getRelocation().getSymbolName())) {
            return false;
        }
        Symbol temp = this.code.getLabel(step.getRelocOffsetValue());
        if (temp == null) {
            return false;
        }
        this.hookfunc = this.hooks.getLocalHook(step.getFunction(), temp.getName());
        return this.hookfunc != null;
    }

    @Override
    public void noMatch(CodeAssembler program, RebuildStep step, Instruction next) {
        System.out.println(next.getOpCode().toInstructionString());
        CodeUtils.printInst(this.code, next);
        CodeInfo.Dump(next, null);
        throw new RuntimeException("Can't transform '" + step.getInstructionString() + "' to redirect to " + this.hookfunc + ". I don't have logic for this instruction form.");
    }

    private class LoadAddress
    implements BaseModify.ModifyVerb {
        private LoadAddress() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m32, imm32".equals(istr) || "MOV r32, imm32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            Symbol temp = Redirect.this.object.getSymbol(Redirect.this.hookfunc);
            program.addInstruction(next);
            step.setRelocOffsetValue(temp.getValue());
        }
    }
}

