/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.hook;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegisters;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeInfo;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.pass.BaseModify;
import crystalpalace.coff.Symbol;
import crystalpalace.export.Hooks;
import crystalpalace.export.ParseImport;

public class Attach
extends BaseModify {
    protected Hooks hooks = null;
    protected ParseImport resolveme = null;
    protected String hookfunc = null;

    @Override
    public void setupVerbs() {
        if (this.x64) {
            this.verbs.add(new MovRax());
            this.verbs.add(new MovNotRax());
            this.verbs.add(new Call64());
            this.verbs.add(new Jmp64());
        } else {
            this.verbs.add(new MovEax());
            this.verbs.add(new MovNotEax());
            this.verbs.add(new Call32());
            this.verbs.add(new Jmp32());
        }
    }

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (!step.hasRelocation()) {
            return false;
        }
        this.resolveme = new ParseImport(step.getRelocation().getSymbolName());
        if (!this.resolveme.isValid()) {
            return false;
        }
        try {
            this.resolveme.checkAndPopulateModule();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.hookfunc = this.hooks.getHook(step.getFunction(), this.resolveme.getTarget());
        return this.hookfunc != null;
    }

    @Override
    public void noMatch(CodeAssembler program, RebuildStep step, Instruction next) {
        System.out.println(next.getOpCode().toInstructionString());
        CodeUtils.printInst(this.code, next);
        CodeInfo.Dump(next, null);
        throw new RuntimeException("Can't transform '" + step.getInstructionString() + "' to attach to API " + step.getRelocation() + ". Change your compiler optimization settings or turn off optimizations for the caller function.");
    }

    public Attach(Code code, Hooks hooks) {
        super(code);
        this.hooks = hooks;
    }

    private class MovRax
    implements BaseModify.ModifyVerb {
        private MovRax() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r64, r/m64".equals(istr) && next.getOp0Register() == 53;
        }

        public boolean isCallRaxNext(RebuildStep step) {
            Instruction peek = step.peekNext();
            if (peek == null) {
                return false;
            }
            return "CALL r/m64".equals(peek.getOpCode().toInstructionString()) && peek.getOp0Register() == 53;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            if (this.isCallRaxNext(step)) {
                step.consumeNext();
                program.call(step.getLabel(Attach.this.hookfunc));
            } else {
                program.lea(new AsmRegister64(new ICRegister(next.getOp0Register())), AsmRegisters.mem_ptr(step.getLabel(Attach.this.hookfunc)));
            }
            step.resolve();
        }
    }

    private class MovNotRax
    implements BaseModify.ModifyVerb {
        private MovNotRax() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r64, r/m64".equals(istr) && next.getOp0Register() != 53;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            program.lea(new AsmRegister64(new ICRegister(next.getOp0Register())), AsmRegisters.mem_ptr(step.getLabel(Attach.this.hookfunc)));
            step.resolve();
        }
    }

    private class MovEax
    implements BaseModify.ModifyVerb {
        private MovEax() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV EAX, moffs32".equals(istr);
        }

        public boolean isCallEaxNext(RebuildStep step) {
            Instruction peek = step.peekNext();
            if (peek == null) {
                return false;
            }
            return "CALL r/m32".equals(peek.getOpCode().toInstructionString()) && peek.getOp0Register() == 37;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            if (this.isCallEaxNext(step)) {
                step.consumeNext();
                program.call(step.getLabel(Attach.this.hookfunc));
                step.resolve();
            } else {
                Symbol temp = Attach.this.object.getSymbol(Attach.this.hookfunc);
                program.mov(new AsmRegister32(new ICRegister(next.getOp0Register())), 0);
                step.getRelocation().setSymbolName(".text");
                step.setRelocOffsetValue(temp.getValue());
            }
        }
    }

    private class MovNotEax
    implements BaseModify.ModifyVerb {
        private MovNotEax() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, r/m32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            Symbol temp = Attach.this.object.getSymbol(Attach.this.hookfunc);
            program.mov(new AsmRegister32(new ICRegister(next.getOp0Register())), 0);
            step.setRelocOffset(1);
            step.getRelocation().setSymbolName(".text");
            step.setRelocOffsetValue(temp.getValue());
        }
    }

    private class Jmp64
    implements BaseModify.ModifyVerb {
        private Jmp64() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "JMP r/m64".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            program.jmp(step.getLabel(Attach.this.hookfunc));
            step.resolve();
        }
    }

    private class Jmp32
    implements BaseModify.ModifyVerb {
        private Jmp32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "JMP r/m32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            program.jmp(step.getLabel(Attach.this.hookfunc));
            step.resolve();
        }
    }

    private class Call32
    implements BaseModify.ModifyVerb {
        private Call32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "CALL r/m32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            program.call(step.getLabel(Attach.this.hookfunc));
            step.resolve();
        }
    }

    private class Call64
    implements BaseModify.ModifyVerb {
        private Call64() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "CALL r/m64".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            program.call(step.getLabel(Attach.this.hookfunc));
            step.resolve();
        }
    }
}

