/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.easypic;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeInfo;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.pass.BaseModify;
import crystalpalace.export.DFR;
import crystalpalace.export.ParseImport;
import crystalpalace.util.ByteWalker;
import crystalpalace.util.Concat;
import crystalpalace.util.CrystalUtils;
import java.util.List;

public class ResolveAPI
extends BaseModify {
    protected DFR resolvers = null;
    protected ParseImport resolveme = null;
    protected DFR.Resolver resolver = null;

    @Override
    public void setupVerbs() {
        if (this.x64) {
            this.verbs.add(new MovRax());
            this.verbs.add(new MovNotRax());
            this.verbs.add(new Call64());
            this.verbs.add(new Jmp64());
        } else {
            this.verbs.add(new MovEax());
            this.verbs.add(new MovNotEax());
            this.verbs.add(new Call32());
            this.verbs.add(new Jmp32());
        }
    }

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (!step.hasRelocation()) {
            return false;
        }
        this.resolveme = new ParseImport(step.getRelocation().getSymbolName());
        if (!this.resolveme.isValid()) {
            return false;
        }
        this.resolveme.checkAndPopulateModule();
        this.resolver = this.resolvers.getResolver(this.resolveme);
        return true;
    }

    @Override
    public void noMatch(CodeAssembler program, RebuildStep step, Instruction next) {
        System.out.println(next.getOpCode().toInstructionString());
        CodeUtils.printInst(this.code, next);
        CodeInfo.Dump(next, null);
        throw new RuntimeException("Can't transform '" + step.getInstructionString() + "' to resolve API " + step.getRelocation() + ". Change your compiler optimization settings or turn off optimizations for the caller function.");
    }

    public ResolveAPI(Code code, DFR resolvers) {
        super(code);
        this.resolvers = resolvers;
    }

    public int pushString(CodeAssembler program, String text) {
        Concat temp = new Concat();
        temp.add(CrystalUtils.toBytes(text, "UTF-8"));
        temp.add(new byte[1]);
        temp.align(this.x64 ? 16 : 8);
        ByteWalker walker = new ByteWalker(CrystalUtils.reverse(temp.get()));
        walker.big();
        int stacklen = 0;
        if (this.x64) {
            AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
            AsmRegister64 rsp = new AsmRegister64(ICRegisters.rsp);
            while (!walker.isComplete()) {
                long val = walker.readLong();
                if (val == 0L) {
                    program.xor(rax, rax);
                    program.push(rax);
                } else {
                    program.mov(rax, val);
                    program.push(rax);
                }
                stacklen += 8;
            }
        } else {
            while (!walker.isComplete()) {
                program.push(walker.readInt());
                stacklen += 4;
            }
        }
        return stacklen;
    }

    public void resolve_strings_x86(CodeAssembler program, RebuildStep step, Instruction next) {
        AsmRegister32 esp = new AsmRegister32(ICRegisters.esp);
        AsmRegister32 ecx = new AsmRegister32(ICRegisters.ecx);
        AsmRegister32 edx = new AsmRegister32(ICRegisters.edx);
        List saved = this.pushad(program);
        int total = 0;
        total += this.pushString(program, this.resolveme.getModule());
        program.mov(ecx, esp);
        program.mov(edx, esp);
        program.push(edx);
        program.push(ecx);
        program.call(step.getLabel(this.resolver.getFunction()));
        program.add(esp, 8 + (total += this.pushString(program, this.resolveme.getFunction())));
        this.popad(program, saved);
        step.resolve();
    }

    public void resolve_ror_x86(CodeAssembler program, RebuildStep step, Instruction next) {
        AsmRegister32 esp = new AsmRegister32(ICRegisters.esp);
        AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
        List saved = this.pushad(program);
        program.push(this.resolveme.getFunctionHash());
        program.push(this.resolveme.getModuleHash());
        program.call(step.getLabel(this.resolver.getFunction()));
        program.add(esp, 8);
        this.popad(program, saved);
        step.resolve();
    }

    public void resolve_x86(CodeAssembler program, RebuildStep step, Instruction next) {
        if (this.resolver.isRor13()) {
            this.resolve_ror_x86(program, step, next);
        } else if (this.resolver.isStrings()) {
            this.resolve_strings_x86(program, step, next);
        } else {
            throw new RuntimeException("Invalid resolve method: " + this.resolver);
        }
    }

    public void resolve_strings_x64(CodeAssembler program, RebuildStep step, Instruction next) {
        AsmRegister64 rcx = new AsmRegister64(ICRegisters.rcx);
        AsmRegister64 rdx = new AsmRegister64(ICRegisters.rdx);
        AsmRegister64 rsp = new AsmRegister64(ICRegisters.rsp);
        List saved = this.pushad(program);
        int total = 0;
        total += this.pushString(program, this.resolveme.getModule());
        program.mov(rcx, rsp);
        program.mov(rdx, rsp);
        this.stackAlloc(program, step.isDirty() ? 40 : 32);
        program.call(step.getLabel(this.resolver.getFunction()));
        this.stackDealloc(program, step.isDirty() ? 40 + total : 32 + (total += this.pushString(program, this.resolveme.getFunction())));
        this.popad(program, saved);
        step.resolve();
    }

    public void resolve_ror_x64(CodeAssembler program, RebuildStep step, Instruction next) {
        AsmRegister32 ecx = new AsmRegister32(ICRegisters.ecx);
        AsmRegister32 edx = new AsmRegister32(ICRegisters.edx);
        List saved = this.pushad(program);
        this.stackAlloc(program, step.isDirty() ? 40 : 32);
        program.mov(ecx, this.resolveme.getModuleHash());
        program.mov(edx, this.resolveme.getFunctionHash());
        program.call(step.getLabel(this.resolver.getFunction()));
        this.stackDealloc(program, step.isDirty() ? 40 : 32);
        this.popad(program, saved);
        step.resolve();
    }

    public void resolve_x64(CodeAssembler program, RebuildStep step, Instruction next) {
        if (this.resolver.isRor13()) {
            this.resolve_ror_x64(program, step, next);
        } else if (this.resolver.isStrings()) {
            this.resolve_strings_x64(program, step, next);
        } else {
            throw new RuntimeException("Invalid resolve method: " + this.resolver);
        }
    }

    private class MovNotRax
    implements BaseModify.ModifyVerb {
        private MovNotRax() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r64, r/m64".equals(istr) && next.getOp0Register() != 53;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
            AsmRegister64 dst = new AsmRegister64(new ICRegister(next.getOp0Register()));
            ResolveAPI.this.pushrax(program);
            ResolveAPI.this.resolve_x64(program, step, next);
            program.mov(dst, rax);
            ResolveAPI.this.poprax(program);
        }
    }

    private class MovRax
    implements BaseModify.ModifyVerb {
        private MovRax() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r64, r/m64".equals(istr) && next.getOp0Register() == 53;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            ResolveAPI.this.resolve_x64(program, step, next);
        }
    }

    private class MovNotEax
    implements BaseModify.ModifyVerb {
        private MovNotEax() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, r/m32".equals(istr) && next.getOp0Register() != 37;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            AsmRegister32 dst = new AsmRegister32(new ICRegister(next.getOp0Register()));
            program.push(eax);
            ResolveAPI.this.resolve_x86(program, step, next);
            program.mov(dst, eax);
            program.pop(eax);
        }
    }

    private class MovEax
    implements BaseModify.ModifyVerb {
        private MovEax() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV EAX, moffs32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            ResolveAPI.this.resolve_x86(program, step, next);
        }
    }

    private class Jmp32
    implements BaseModify.ModifyVerb {
        private Jmp32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "JMP r/m32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            ResolveAPI.this.resolve_x86(program, step, next);
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            program.jmp(eax);
        }
    }

    private class Jmp64
    implements BaseModify.ModifyVerb {
        private Jmp64() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "JMP r/m64".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            ResolveAPI.this.resolve_x64(program, step, next);
            AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
            program.jmp(rax);
        }
    }

    private class Call32
    implements BaseModify.ModifyVerb {
        private Call32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "CALL r/m32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            ResolveAPI.this.resolve_x86(program, step, next);
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            program.call(eax);
        }
    }

    private class Call64
    implements BaseModify.ModifyVerb {
        private Call64() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "CALL r/m64".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            ResolveAPI.this.resolve_x64(program, step, next);
            AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
            program.call(rax);
        }
    }
}

