/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.easypic;

import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.Code;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.pass.easypic.FixBaseX86;
import crystalpalace.export.ParseImport;
import java.util.List;

public class FixX86References
extends FixBaseX86 {
    protected String retaddr = null;

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (this.x64) {
            return false;
        }
        if (!step.hasRelocation()) {
            return false;
        }
        ParseImport resolveme = new ParseImport(step.getRelocation().getSymbolName());
        if (resolveme.isValid()) {
            return false;
        }
        if (step.getRelocation().isSection(".bss")) {
            return false;
        }
        String istr = next.getOpCode().toInstructionString();
        return !"CALL rel32".equals(istr);
    }

    public FixX86References(Code code, String retaddr) {
        super(code);
        this.retaddr = retaddr;
    }

    @Override
    public void callFixHelper(CodeAssembler program, RebuildStep step) {
        this.checkDanger(program, step);
        AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
        AsmRegister32 ecx = new AsmRegister32(ICRegisters.ecx);
        List saved = this.pushad(program);
        program.call(step.getLabel(this.retaddr));
        step.createLabel(program);
        step.setRelocOffset(1);
        program.mov(ecx, 0);
        program.add(ecx, 5);
        program.add(eax, ecx);
        this.popad(program, saved);
    }
}

