/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.easypic;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegisters;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeInfo;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.pass.BaseModify;
import crystalpalace.btf.pass.RegValue;
import crystalpalace.util.CrystalUtils;
import java.util.HashSet;
import java.util.Set;

public abstract class FixBaseX86
extends BaseModify {
    @Override
    public void setupVerbs() {
        this.verbs.add(new AddEax());
        this.verbs.add(new Call32());
        this.verbs.add(new CmpEax());
        this.verbs.add(new CompareConstant());
        this.verbs.add(new LoadAddress());
        this.verbs.add(new LoadAddressLEA());
        this.verbs.add(new LoadAddressReg());
        this.verbs.add(new LoadEAX());
        this.verbs.add(new Load32_8_S());
        this.verbs.add(new Load32_8_Z());
        this.verbs.add(new Load32_16_S());
        this.verbs.add(new Load32_16_Z());
        this.verbs.add(new Load32_32());
        this.verbs.add(new Store32_32());
        this.verbs.add(new Store32_16());
        this.verbs.add(new Store32_8());
        this.verbs.add(new StoreConstant());
    }

    @Override
    public void noMatch(CodeAssembler program, RebuildStep step, Instruction next) {
        CodeUtils.p(step);
        CodeInfo.Dump(next, null);
        throw new RuntimeException(this.getClass().getSimpleName() + ": Can't transform '" + step.getInstructionString() + "' to handle " + step.getRelocation() + ". Change your compiler optimization settings or turn off optimizations for " + step.getFunction());
    }

    public FixBaseX86(Code code) {
        super(code);
    }

    protected void checkDanger(CodeAssembler program, RebuildStep step) {
        if (!step.isDangerous()) {
            return;
        }
        CodeUtils.p(step);
        throw new RuntimeException(this.getClass().getSimpleName() + ": Possible eflags corruption if I transform '" + step.getInstructionString() + "' to handle " + step.getRelocation() + ". Change your compiler optimization settings or turn off optimizations for " + step.getFunction());
    }

    public abstract void callFixHelper(CodeAssembler var1, RebuildStep var2);

    private class Store32_8
    extends StoreValue32 {
        private Store32_8() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            if ("MOV moffs8, AL".equals(istr)) {
                return true;
            }
            return "MOV r/m8, r8".equals(istr) && next.getMemoryBase() == 0;
        }

        @Override
        public AsmRegister32 getTmpReg(AsmRegister32 _rax) {
            switch (FixBaseX86.this.nextInt(3)) {
                case 0: {
                    return new AsmRegister32(ICRegisters.ebx);
                }
                case 1: {
                    return new AsmRegister32(ICRegisters.ecx);
                }
                case 2: {
                    return new AsmRegister32(ICRegisters.edx);
                }
            }
            throw new RuntimeException("Bad tmp reg");
        }

        @Override
        public boolean is(RegValue rax, RegValue src) {
            return rax.getReg8().equals(src.getReg8());
        }

        @Override
        public void copyTemp(CodeAssembler program, RegValue tmp, RegValue src) {
            program.mov(tmp.getReg8(), src.getReg8());
        }

        @Override
        public void storeValue(CodeAssembler program, RegValue dst, RegValue src) {
            program.mov(AsmRegisters.byte_ptr(dst.getReg32(), 0L), src.getReg8());
        }
    }

    private class Store32_16
    extends StoreValue32 {
        private Store32_16() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            if ("MOV moffs16, AX".equals(istr)) {
                return true;
            }
            return "MOV r/m16, r16".equals(istr) && next.getMemoryBase() == 0;
        }

        @Override
        public boolean is(RegValue rax, RegValue src) {
            return rax.getReg16().equals(src.getReg16());
        }

        @Override
        public void copyTemp(CodeAssembler program, RegValue tmp, RegValue src) {
            program.mov(tmp.getReg16(), src.getReg16());
        }

        @Override
        public void storeValue(CodeAssembler program, RegValue dst, RegValue src) {
            program.mov(AsmRegisters.word_ptr(dst.getReg32(), 0L), src.getReg16());
        }
    }

    private class Store32_32
    extends StoreValue32 {
        private Store32_32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            if ("MOV moffs32, EAX".equals(istr)) {
                return true;
            }
            return "MOV r/m32, r32".equals(istr) && next.getMemoryBase() == 0;
        }

        @Override
        public boolean is(RegValue rax, RegValue src) {
            return rax.getReg32().equals(src.getReg32());
        }

        @Override
        public void copyTemp(CodeAssembler program, RegValue tmp, RegValue src) {
            program.mov(tmp.getReg32(), src.getReg32());
        }

        @Override
        public void storeValue(CodeAssembler program, RegValue dst, RegValue src) {
            program.mov(AsmRegisters.mem_ptr(dst.getReg32(), 0L), src.getReg32());
        }
    }

    private abstract class StoreValue32
    implements BaseModify.ModifyVerb {
        private StoreValue32() {
        }

        public abstract boolean is(RegValue var1, RegValue var2);

        public abstract void copyTemp(CodeAssembler var1, RegValue var2, RegValue var3);

        public abstract void storeValue(CodeAssembler var1, RegValue var2, RegValue var3);

        public AsmRegister32 getTmpReg(AsmRegister32 _rax) {
            return FixBaseX86.this.getRandReg32(_rax);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 _rax = new AsmRegister32(ICRegisters.eax);
            AsmRegister32 _tmp = this.getTmpReg(_rax);
            RegValue rax = RegValue.toRegValue(_rax);
            RegValue tmp = RegValue.toRegValue(_tmp);
            RegValue src = RegValue.toRegValue(next, 1);
            program.push(_rax);
            if (this.is(rax, src)) {
                program.push(_tmp);
                this.copyTemp(program, tmp, rax);
                FixBaseX86.this.callFixHelper(program, step);
                this.storeValue(program, rax, tmp);
                program.pop(_tmp);
            } else {
                FixBaseX86.this.callFixHelper(program, step);
                this.storeValue(program, rax, src);
            }
            program.pop(_rax);
        }
    }

    private class LoadAddressReg
    implements BaseModify.ModifyVerb {
        private LoadAddressReg() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, imm32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            AsmRegister32 dst = new AsmRegister32(new ICRegister(next.getOp0Register()));
            if (dst.equals(eax)) {
                FixBaseX86.this.callFixHelper(program, step);
            } else {
                program.push(eax);
                FixBaseX86.this.callFixHelper(program, step);
                program.mov(dst, eax);
                program.pop(eax);
            }
        }
    }

    private class LoadAddressLEA
    implements BaseModify.ModifyVerb {
        private LoadAddressLEA() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "LEA r32, m".equals(istr) && next.getMemoryBase() != 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            AsmRegister32 esp = new AsmRegister32(ICRegisters.esp);
            AsmRegister32 dst = new AsmRegister32(new ICRegister(next.getOp0Register()));
            AsmRegister32 base = new AsmRegister32(new ICRegister(next.getMemoryBase()));
            program.sub(esp, 4);
            program.mov(FixBaseX86.this.getStackPtr(), base);
            if (dst.equals(eax)) {
                CrystalUtils.print_warn(this.getClass().getSimpleName() + " LEA %eax, m found. Transform exists, but is untested.");
                CodeUtils.p(step);
                FixBaseX86.this.callFixHelper(program, step);
                program.add(eax, FixBaseX86.this.getStackPtr(0));
            } else {
                program.push(eax);
                FixBaseX86.this.callFixHelper(program, step);
                program.add(eax, FixBaseX86.this.getStackPtr(4));
                program.mov(dst, eax);
                program.pop(eax);
            }
            program.add(esp, 4);
        }
    }

    private class LoadAddress
    implements BaseModify.ModifyVerb {
        private LoadAddress() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m32, imm32".equals(istr) && next.getMemoryBase() != 0 && next.getMemoryIndex() == 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            AsmRegister32 ecx = new AsmRegister32(ICRegisters.ecx);
            AsmMemoryOperand dst = FixBaseX86.this.getMemOperand(next);
            if (!step.isRelocImmediate()) {
                FixBaseX86.this.noMatch(program, step, next);
            }
            if (next.getMemoryBase() == 37) {
                program.push(ecx);
                program.push(eax);
                FixBaseX86.this.callFixHelper(program, step);
                program.mov(ecx, eax);
                program.pop(eax);
                program.mov(dst, ecx);
                program.pop(ecx);
            } else {
                program.push(eax);
                FixBaseX86.this.callFixHelper(program, step);
                if (next.getMemoryBase() == 41) {
                    dst = dst.add(4L);
                }
                program.mov(dst, eax);
                program.pop(eax);
            }
        }
    }

    private class LoadEAX
    implements BaseModify.ModifyVerb {
        private LoadEAX() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV EAX, moffs32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            FixBaseX86.this.callFixHelper(program, step);
            program.mov(eax, AsmRegisters.mem_ptr(eax, 0L));
        }
    }

    private class Load32_32
    extends LoadValue32 {
        private Load32_32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, r/m32".equals(istr) && this.isGood(next);
        }

        @Override
        protected void load(CodeAssembler program, Instruction next, AsmRegister32 dst, AsmRegister32 src) {
            program.mov(dst, AsmRegisters.mem_ptr(src, 0L));
        }
    }

    private class Load32_16_S
    extends LoadValue32 {
        private Load32_16_S() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOVSX r32, r/m16".equals(istr) && this.isGood(next);
        }

        @Override
        protected void load(CodeAssembler program, Instruction next, AsmRegister32 dst, AsmRegister32 src) {
            program.movsx(dst, AsmRegisters.word_ptr(src, 0L));
        }
    }

    private class Load32_8_S
    extends LoadValue32 {
        private Load32_8_S() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOVSX r32, r/m8".equals(istr) && this.isGood(next);
        }

        @Override
        protected void load(CodeAssembler program, Instruction next, AsmRegister32 dst, AsmRegister32 src) {
            program.movsx(dst, AsmRegisters.byte_ptr(src, 0L));
        }
    }

    private class Load32_16_Z
    extends LoadValue32 {
        private Load32_16_Z() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOVZX r32, r/m16".equals(istr) && this.isGood(next);
        }

        @Override
        protected void load(CodeAssembler program, Instruction next, AsmRegister32 dst, AsmRegister32 src) {
            program.movzx(dst, AsmRegisters.word_ptr(src, 0L));
        }
    }

    private class Load32_8_Z
    extends LoadValue32 {
        private Load32_8_Z() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOVZX r32, r/m8".equals(istr) && this.isGood(next);
        }

        @Override
        protected void load(CodeAssembler program, Instruction next, AsmRegister32 dst, AsmRegister32 src) {
            program.movzx(dst, AsmRegisters.byte_ptr(src, 0L));
        }
    }

    private abstract class LoadValue32
    implements BaseModify.ModifyVerb {
        private LoadValue32() {
        }

        protected abstract void load(CodeAssembler var1, Instruction var2, AsmRegister32 var3, AsmRegister32 var4);

        public boolean isGood(Instruction next) {
            if (next.getMemoryBase() == 0) {
                return true;
            }
            if (next.getMemoryBase() == 41 || next.getMemoryBase() == 42) {
                return false;
            }
            return next.getMemoryIndex() == 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 dst = new AsmRegister32(new ICRegister(next.getOp0Register()));
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            AsmRegister32 esp = new AsmRegister32(ICRegisters.esp);
            if (next.getMemoryBase() != 0) {
                AsmRegister32 base = new AsmRegister32(new ICRegister(next.getMemoryBase()));
                program.sub(esp, 4);
                program.mov(FixBaseX86.this.getStackPtr(), base);
                if (dst.equals(eax)) {
                    FixBaseX86.this.callFixHelper(program, step);
                    program.add(eax, FixBaseX86.this.getStackPtr(0));
                    this.load(program, next, eax, eax);
                } else {
                    program.push(eax);
                    FixBaseX86.this.callFixHelper(program, step);
                    program.add(eax, FixBaseX86.this.getStackPtr(4));
                    this.load(program, next, dst, eax);
                    program.pop(eax);
                }
                program.add(esp, 4);
            } else if (dst.equals(eax)) {
                FixBaseX86.this.callFixHelper(program, step);
                this.load(program, next, eax, eax);
            } else {
                program.push(eax);
                FixBaseX86.this.callFixHelper(program, step);
                this.load(program, next, dst, eax);
                program.pop(eax);
            }
        }
    }

    private class StoreConstant
    implements BaseModify.ModifyVerb {
        protected Set valid = new HashSet();

        public StoreConstant() {
            this.valid.add("MOV r/m8, imm8");
            this.valid.add("MOV r/m16, imm16");
            this.valid.add("MOV r/m32, imm32");
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return this.valid.contains(istr) && next.getMemoryBase() == 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            int val = next.getImmediate32();
            String istr = next.getOpCode().toInstructionString();
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            if (!step.isRelocDisplacement()) {
                FixBaseX86.this.noMatch(program, step, next);
            }
            program.push(eax);
            FixBaseX86.this.callFixHelper(program, step);
            if ("MOV r/m8, imm8".equals(istr)) {
                program.mov(AsmRegisters.byte_ptr(eax, 0L), val);
            } else if ("MOV r/m16, imm16".equals(istr)) {
                program.mov(AsmRegisters.word_ptr(eax, 0L), val);
            } else if ("MOV r/m32, imm32".equals(istr)) {
                program.mov(AsmRegisters.dword_ptr(eax, 0L), val);
            } else {
                throw new RuntimeException("Invalid istr " + istr + " in x86 StoreConstant");
            }
            program.pop(eax);
        }
    }

    private class CmpEax
    implements BaseModify.ModifyVerb {
        private CmpEax() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "CMP EAX, imm32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            AsmRegister32 ecx = new AsmRegister32(ICRegisters.ecx);
            program.push(ecx);
            program.push(eax);
            FixBaseX86.this.callFixHelper(program, step);
            program.mov(ecx, eax);
            program.pop(eax);
            program.cmp(eax, ecx);
            program.pop(ecx);
        }
    }

    private class CompareConstant
    implements BaseModify.ModifyVerb {
        protected Set valid = new HashSet();

        public CompareConstant() {
            this.valid.add("CMP r/m8, imm8");
            this.valid.add("CMP r/m16, imm16");
            this.valid.add("CMP r/m32, imm32");
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return this.valid.contains(istr) && next.getMemoryBase() == 0;
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            int val = next.getImmediate32();
            String istr = next.getOpCode().toInstructionString();
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            program.push(eax);
            FixBaseX86.this.callFixHelper(program, step);
            if ("CMP r/m8, imm8".equals(istr)) {
                program.cmp(AsmRegisters.byte_ptr(eax, 0L), val);
            } else if ("CMP r/m16, imm16".equals(istr)) {
                program.cmp(AsmRegisters.word_ptr(eax, 0L), val);
            } else if ("CMP r/m32, imm32".equals(istr)) {
                program.cmp(AsmRegisters.dword_ptr(eax, 0L), val);
            } else {
                throw new RuntimeException("Invalid istr " + istr + " in x86 CompareConstant");
            }
            program.pop(eax);
        }
    }

    private class Call32
    implements BaseModify.ModifyVerb {
        private Call32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "CALL r/m32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            FixBaseX86.this.callFixHelper(program, step);
            program.mov(eax, AsmRegisters.mem_ptr(eax, 0L));
            program.call(eax);
        }
    }

    private class AddEax
    implements BaseModify.ModifyVerb {
        private AddEax() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "ADD EAX, imm32".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            AsmRegister32 ecx = new AsmRegister32(ICRegisters.ecx);
            program.push(ecx);
            program.push(eax);
            FixBaseX86.this.callFixHelper(program, step);
            program.mov(ecx, eax);
            program.pop(eax);
            program.add(eax, ecx);
            program.pop(ecx);
        }
    }
}

