/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.easypic;

import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.Code;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.pass.easypic.FixBaseX86;
import java.util.List;

public class FixBSSReferencesX86
extends FixBaseX86 {
    protected String getbss = null;
    protected int bsssize = 0;

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (!step.hasRelocation()) {
            return false;
        }
        return step.getRelocation().isSection(".bss");
    }

    public FixBSSReferencesX86(Code code, String getbss) {
        super(code);
        this.getbss = getbss;
    }

    @Override
    public void callFixHelper(CodeAssembler program, RebuildStep step) {
        this.checkDanger(program, step);
        AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
        AsmRegister32 esp = new AsmRegister32(ICRegisters.esp);
        int bsslen = this.object.getSection(".bss").getRawData().length;
        List saved = this.pushad(program);
        program.push(bsslen);
        program.call(step.getLabel(this.getbss));
        program.add(esp, 4);
        this.popad(program, saved);
        program.add(eax, step.getRelocation().getRemoteSectionOffset());
        step.resolve();
    }
}

