/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.easypic;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegisters;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeInfo;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.pass.BaseModify;
import crystalpalace.btf.pass.RegValue;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FixBSSReferencesX64
extends BaseModify {
    protected String getbss = null;
    protected int bsssize = 0;

    @Override
    public void setupVerbs() {
        this.verbs.add(new Call64());
        this.verbs.add(new LoadAddress());
        this.verbs.add(new Load32_8_S());
        this.verbs.add(new Load32_8_Z());
        this.verbs.add(new Load32_16_S());
        this.verbs.add(new Load32_16_Z());
        this.verbs.add(new Load32_32());
        this.verbs.add(new Load64_64());
        this.verbs.add(new Store8());
        this.verbs.add(new Store16());
        this.verbs.add(new Store32());
        this.verbs.add(new Store64());
        this.verbs.add(new CompareConstant());
        this.verbs.add(new StoreConstant());
    }

    @Override
    public boolean shouldModify(RebuildStep step, Instruction next) {
        if (!step.hasRelocation()) {
            return false;
        }
        return step.getRelocation().isSection(".bss");
    }

    @Override
    public void noMatch(CodeAssembler program, RebuildStep step, Instruction next) {
        CodeUtils.p(step);
        CodeInfo.Dump(next, null);
        throw new RuntimeException(this.getClass().getSimpleName() + ": Can't transform '" + step.getInstructionString() + "' to handle " + step.getRelocation() + ". Change your compiler optimization settings or turn off optimizations for " + step.getFunction());
    }

    protected void checkDanger(CodeAssembler program, RebuildStep step) {
        if (!step.isDangerous()) {
            return;
        }
        CodeUtils.p(step);
        throw new RuntimeException(this.getClass().getSimpleName() + ": Possible rflags corruption if I transform '" + step.getInstructionString() + "' to handle " + step.getRelocation() + ". Change your compiler optimization settings or turn off optimizations for " + step.getFunction());
    }

    public FixBSSReferencesX64(Code code, String getbss) {
        super(code);
        this.getbss = getbss;
    }

    public void callGetBSS(CodeAssembler program, RebuildStep step) {
        this.checkDanger(program, step);
        int bsslen = this.object.getSection(".bss").getRawData().length;
        AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
        AsmRegister32 ecx = new AsmRegister32(ICRegisters.ecx);
        List saved = this.pushad(program);
        this.stackAlloc(program, step.isDirty() ? 40 : 32);
        program.mov(ecx, bsslen);
        program.call(step.getLabel(this.getbss));
        this.stackDealloc(program, step.isDirty() ? 40 : 32);
        this.popad(program, saved);
        int bssoffset = step.getInstructionLength() - (step.getRelocOffset() + step.getRelocation().getFromOffset());
        if ((bssoffset += step.getRelocation().getRemoteSectionOffset()) != 0) {
            program.add(rax, bssoffset);
        }
        step.resolve();
    }

    private class LoadAddress
    implements BaseModify.ModifyVerb {
        private LoadAddress() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "LEA r64, m".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
            AsmRegister64 dst = new AsmRegister64(new ICRegister(next.getOp0Register()));
            if (dst.equals(rax)) {
                FixBSSReferencesX64.this.callGetBSS(program, step);
            } else {
                FixBSSReferencesX64.this.pushrax(program);
                FixBSSReferencesX64.this.callGetBSS(program, step);
                program.mov(dst, rax);
                FixBSSReferencesX64.this.poprax(program);
            }
        }
    }

    private class Load64_64
    implements BaseModify.ModifyVerb {
        private Load64_64() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r64, r/m64".equals(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister64 rax;
            AsmRegister64 dst = new AsmRegister64(new ICRegister(next.getOp0Register()));
            if (dst.equals(rax = new AsmRegister64(ICRegisters.rax))) {
                FixBSSReferencesX64.this.callGetBSS(program, step);
                program.mov(rax, AsmRegisters.mem_ptr(rax, 0L));
            } else {
                FixBSSReferencesX64.this.pushrax(program);
                FixBSSReferencesX64.this.callGetBSS(program, step);
                program.mov(dst, AsmRegisters.mem_ptr(rax, 0L));
                FixBSSReferencesX64.this.poprax(program);
            }
        }
    }

    private class Load32_32
    extends LoadValue32 {
        private Load32_32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r32, r/m32".equals(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public void loadValue(CodeAssembler program, AsmRegister32 dst, AsmRegister64 src) {
            program.mov(dst, AsmRegisters.mem_ptr(src, 0L));
        }
    }

    private class Load32_16_S
    extends LoadValue32 {
        private Load32_16_S() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOVSX r32, r/m16".equals(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public void loadValue(CodeAssembler program, AsmRegister32 dst, AsmRegister64 src) {
            program.movsx(dst, AsmRegisters.word_ptr(src, 0L));
        }
    }

    private class Load32_8_S
    extends LoadValue32 {
        private Load32_8_S() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOVSX r32, r/m8".equals(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public void loadValue(CodeAssembler program, AsmRegister32 dst, AsmRegister64 src) {
            program.movsx(dst, AsmRegisters.byte_ptr(src, 0L));
        }
    }

    private class Load32_16_Z
    extends LoadValue32 {
        private Load32_16_Z() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOVZX r32, r/m16".equals(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public void loadValue(CodeAssembler program, AsmRegister32 dst, AsmRegister64 src) {
            program.movzx(dst, AsmRegisters.word_ptr(src, 0L));
        }
    }

    private class Load32_8_Z
    extends LoadValue32 {
        private Load32_8_Z() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOVZX r32, r/m8".equals(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public void loadValue(CodeAssembler program, AsmRegister32 dst, AsmRegister64 src) {
            program.movzx(dst, AsmRegisters.byte_ptr(src, 0L));
        }
    }

    private abstract class LoadValue32
    implements BaseModify.ModifyVerb {
        private LoadValue32() {
        }

        public abstract void loadValue(CodeAssembler var1, AsmRegister32 var2, AsmRegister64 var3);

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister32 dst = new AsmRegister32(new ICRegister(next.getOp0Register()));
            AsmRegister32 eax = new AsmRegister32(ICRegisters.eax);
            AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
            if (dst.equals(eax)) {
                FixBSSReferencesX64.this.callGetBSS(program, step);
                this.loadValue(program, eax, rax);
            } else {
                FixBSSReferencesX64.this.pushrax(program);
                FixBSSReferencesX64.this.callGetBSS(program, step);
                this.loadValue(program, dst, rax);
                FixBSSReferencesX64.this.poprax(program);
            }
        }
    }

    private class Store64
    extends StoreValue {
        private Store64() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m64, r64".equals(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public boolean is(RegValue rax, RegValue src) {
            return rax.getReg64().equals(src.getReg64());
        }

        @Override
        public void copyTemp(CodeAssembler program, RegValue tmp, RegValue src) {
            program.mov(tmp.getReg64(), src.getReg64());
        }

        @Override
        public void storeValue(CodeAssembler program, RegValue dst, RegValue src) {
            program.mov(AsmRegisters.mem_ptr(dst.getReg64(), 0L), src.getReg64());
        }
    }

    private class Store32
    extends StoreValue {
        private Store32() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m32, r32".equals(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public boolean is(RegValue rax, RegValue src) {
            return rax.getReg32().equals(src.getReg32());
        }

        @Override
        public void copyTemp(CodeAssembler program, RegValue tmp, RegValue src) {
            program.mov(tmp.getReg32(), src.getReg32());
        }

        @Override
        public void storeValue(CodeAssembler program, RegValue dst, RegValue src) {
            program.mov(AsmRegisters.mem_ptr(dst.getReg64(), 0L), src.getReg32());
        }
    }

    private class Store16
    extends StoreValue {
        private Store16() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m16, r16".equals(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public boolean is(RegValue rax, RegValue src) {
            return rax.getReg16().equals(src.getReg16());
        }

        @Override
        public void copyTemp(CodeAssembler program, RegValue tmp, RegValue src) {
            program.mov(tmp.getReg16(), src.getReg16());
        }

        @Override
        public void storeValue(CodeAssembler program, RegValue dst, RegValue src) {
            program.mov(AsmRegisters.mem_ptr(dst.getReg64(), 0L), src.getReg16());
        }
    }

    private class Store8
    extends StoreValue {
        private Store8() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "MOV r/m8, r8".equals(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public boolean is(RegValue rax, RegValue src) {
            return rax.getReg8().equals(src.getReg8());
        }

        @Override
        public void copyTemp(CodeAssembler program, RegValue tmp, RegValue src) {
            program.mov(tmp.getReg8(), src.getReg8());
        }

        @Override
        public void storeValue(CodeAssembler program, RegValue dst, RegValue src) {
            program.mov(AsmRegisters.mem_ptr(dst.getReg64(), 0L), src.getReg8());
        }
    }

    private abstract class StoreValue
    implements BaseModify.ModifyVerb {
        private StoreValue() {
        }

        public abstract boolean is(RegValue var1, RegValue var2);

        public abstract void copyTemp(CodeAssembler var1, RegValue var2, RegValue var3);

        public abstract void storeValue(CodeAssembler var1, RegValue var2, RegValue var3);

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister64 _rax = new AsmRegister64(ICRegisters.rax);
            AsmRegister64 _tmp = FixBSSReferencesX64.this.getRandReg64(_rax);
            RegValue rax = RegValue.toRegValue(_rax);
            RegValue tmp = RegValue.toRegValue(_tmp);
            RegValue src = RegValue.toRegValue(next, 1);
            if (this.is(rax, src)) {
                program.push(_rax);
                program.push(_tmp);
                this.copyTemp(program, tmp, src);
                FixBSSReferencesX64.this.callGetBSS(program, step);
                this.storeValue(program, rax, tmp);
                program.pop(_tmp);
                program.pop(_rax);
            } else {
                FixBSSReferencesX64.this.pushrax(program);
                FixBSSReferencesX64.this.callGetBSS(program, step);
                this.storeValue(program, rax, src);
                FixBSSReferencesX64.this.poprax(program);
            }
        }
    }

    private class StoreConstant
    implements BaseModify.ModifyVerb {
        protected Set valid = new HashSet();

        public StoreConstant() {
            this.valid.add("MOV r/m8, imm8");
            this.valid.add("MOV r/m16, imm16");
            this.valid.add("MOV r/m32, imm32");
            this.valid.add("MOV r/m64, imm32");
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return this.valid.contains(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            int val = next.getImmediate32();
            String istr = next.getOpCode().toInstructionString();
            AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
            FixBSSReferencesX64.this.pushrax(program);
            FixBSSReferencesX64.this.callGetBSS(program, step);
            if ("MOV r/m8, imm8".equals(istr)) {
                program.mov(AsmRegisters.byte_ptr(rax, 0L), val);
            } else if ("MOV r/m16, imm16".equals(istr)) {
                program.mov(AsmRegisters.word_ptr(rax, 0L), val);
            } else if ("MOV r/m32, imm32".equals(istr)) {
                program.mov(AsmRegisters.dword_ptr(rax, 0L), val);
            } else if ("MOV r/m64, imm32".equals(istr)) {
                program.mov(AsmRegisters.qword_ptr(rax, 0L), val);
            } else {
                throw new RuntimeException("Invalid istr " + istr + " in StoreConstant");
            }
            FixBSSReferencesX64.this.poprax(program);
        }
    }

    private class CompareConstant
    implements BaseModify.ModifyVerb {
        protected Set valid = new HashSet();

        public CompareConstant() {
            this.valid.add("CMP r/m8, imm8");
            this.valid.add("CMP r/m16, imm16");
            this.valid.add("CMP r/m32, imm32");
            this.valid.add("CMP r/m64, imm32");
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return this.valid.contains(istr) && next.isIPRelativeMemoryOperand();
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            int val = next.getImmediate32();
            String istr = next.getOpCode().toInstructionString();
            AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
            FixBSSReferencesX64.this.pushrax(program);
            FixBSSReferencesX64.this.callGetBSS(program, step);
            if ("CMP r/m8, imm8".equals(istr)) {
                program.cmp(AsmRegisters.byte_ptr(rax, 0L), val);
            } else if ("CMP r/m16, imm16".equals(istr)) {
                program.cmp(AsmRegisters.word_ptr(rax, 0L), val);
            } else if ("CMP r/m32, imm32".equals(istr)) {
                program.cmp(AsmRegisters.dword_ptr(rax, 0L), val);
            } else if ("CMP r/m64, imm32".equals(istr)) {
                program.cmp(AsmRegisters.qword_ptr(rax, 0L), val);
            } else {
                throw new RuntimeException("Invalid istr " + istr + " in CompareConstant");
            }
            FixBSSReferencesX64.this.poprax(program);
        }
    }

    private class Call64
    implements BaseModify.ModifyVerb {
        private Call64() {
        }

        @Override
        public boolean check(String istr, Instruction next) {
            return "CALL r/m64".equals(istr);
        }

        @Override
        public void apply(CodeAssembler program, RebuildStep step, Instruction next) {
            AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
            FixBSSReferencesX64.this.callGetBSS(program, step);
            program.mov(rax, AsmRegisters.mem_ptr(rax, 0L));
            program.call(rax);
        }
    }
}

