/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass.easypic;

import com.github.icedland.iced.x86.Instruction;
import crystalpalace.btf.Code;
import crystalpalace.btf.pass.CallWalk;
import java.util.Map;

public class DangerWalk
extends CallWalk {
    protected String start = null;

    public DangerWalk(Code code, String start) {
        super(code);
        this.start = start;
    }

    @Override
    public void check(String parent, String symbol, Instruction inst) {
        if ("x64".equals(this.object.getMachine()) ? "dprintf".equals(symbol) : "_dprintf".equals(symbol)) {
            throw new RuntimeException("Don't call dprintf from dfr/fixptrs/fixbss. OutputDebugStringA's message propagation (SEHs) can corrupt from these contexts. (" + this.start + " -> " + parent + ")");
        }
    }

    public Map apply(Map _funcs) {
        this.funcs = _funcs;
        if ("x64".equals(this.object.getMachine())) {
            this.walk_x64(this.start);
        } else {
            this.walk_x86(this.start);
        }
        return this.funcs;
    }
}

