/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister16;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegister8;
import crystalpalace.btf.pass.RegConvert;

public abstract class RegValue {
    public abstract AsmRegister8 getReg8();

    public abstract AsmRegister16 getReg16();

    public abstract AsmRegister32 getReg32();

    public abstract AsmRegister64 getReg64();

    public static RegValue toRegValue(AsmRegister64 reg) {
        return new RegValue64(reg);
    }

    public static RegValue toRegValue(AsmRegister32 reg) {
        return new RegValue32(reg);
    }

    public static RegValue toRegValue(Instruction next, int opNo) {
        return new RegValueInst(next, opNo);
    }

    private static class RegValueInst
    extends RegValue {
        protected Instruction next;
        protected int opNo;

        public RegValueInst(Instruction next, int opNo) {
            this.next = next;
            this.opNo = opNo;
        }

        public ICRegister getOpReg() {
            if (this.opNo == 0) {
                return new ICRegister(this.next.getOp0Register());
            }
            if (this.opNo == 1) {
                return new ICRegister(this.next.getOp1Register());
            }
            throw new RuntimeException("getOpreg() doesn't support " + this.opNo);
        }

        @Override
        public AsmRegister8 getReg8() {
            return new AsmRegister8(this.getOpReg());
        }

        @Override
        public AsmRegister16 getReg16() {
            return new AsmRegister16(this.getOpReg());
        }

        @Override
        public AsmRegister32 getReg32() {
            return new AsmRegister32(this.getOpReg());
        }

        @Override
        public AsmRegister64 getReg64() {
            return new AsmRegister64(this.getOpReg());
        }
    }

    private static class RegValue32
    extends RegValue {
        protected AsmRegister32 reg;

        public RegValue32(AsmRegister32 reg) {
            this.reg = reg;
        }

        @Override
        public AsmRegister8 getReg8() {
            return RegConvert.toReg8(this.reg);
        }

        @Override
        public AsmRegister16 getReg16() {
            return RegConvert.toReg16(this.reg);
        }

        @Override
        public AsmRegister32 getReg32() {
            return this.reg;
        }

        @Override
        public AsmRegister64 getReg64() {
            throw new RuntimeException("I won't convert a 32b base reg to 64b - not implemented");
        }
    }

    private static class RegValue64
    extends RegValue {
        protected AsmRegister64 reg;

        public RegValue64(AsmRegister64 reg) {
            this.reg = reg;
        }

        @Override
        public AsmRegister8 getReg8() {
            return RegConvert.toReg8(this.reg);
        }

        @Override
        public AsmRegister16 getReg16() {
            return RegConvert.toReg16(this.reg);
        }

        @Override
        public AsmRegister32 getReg32() {
            return RegConvert.toReg32(this.reg);
        }

        @Override
        public AsmRegister64 getReg64() {
            return this.reg;
        }
    }
}

