/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.pass;

import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.asm.AsmMemoryOperand;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegisters;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import crystalpalace.btf.RebuildStep;
import crystalpalace.util.ByteWalker;
import crystalpalace.util.Concat;
import crystalpalace.util.CrystalUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MiniFrame {
    protected int size = 0;
    protected List slots = new LinkedList();

    public MiniFrame() {
        this.size += 32;
    }

    public AsmMemoryOperand getStackPtr() {
        return AsmRegisters.mem_ptr(new AsmRegister64(ICRegisters.rsp), (long)this.size);
    }

    public AsmMemoryOperand getAndIncStackPtr() {
        AsmMemoryOperand value = this.getStackPtr();
        this.size += 8;
        return value;
    }

    public void saveRegs(RebuildStep step) {
        LinkedList<AsmRegister64> regs = new LinkedList<AsmRegister64>();
        regs.add(new AsmRegister64(ICRegisters.rcx));
        regs.add(new AsmRegister64(ICRegisters.rdx));
        regs.add(new AsmRegister64(ICRegisters.r8));
        regs.add(new AsmRegister64(ICRegisters.r9));
        regs.add(new AsmRegister64(ICRegisters.r10));
        regs.add(new AsmRegister64(ICRegisters.r11));
        Collections.shuffle(regs);
        Iterator i = regs.iterator();
        while (i.hasNext()) {
            this.slots.add(new RegSlot((AsmRegister64)i.next(), this.getAndIncStackPtr()));
        }
    }

    public AsmMemoryOperand pushString(String text) {
        Concat temp = new Concat();
        temp.add(CrystalUtils.toBytes(text, "UTF-8"));
        temp.add(new byte[1]);
        temp.align(16);
        AsmMemoryOperand location = this.getStackPtr();
        ByteWalker walker = new ByteWalker(temp.get());
        walker.little();
        while (!walker.isComplete()) {
            long val = walker.readLong();
            this.slots.add(new ConstantSlot(val, this.getAndIncStackPtr()));
        }
        return location;
    }

    public void start(CodeAssembler program) {
        if (this.size % 16 != 0) {
            throw new RuntimeException("MiniFrame x64 alignment is: " + this.size % 16 + " which is not MOD 16");
        }
        AsmRegister64 rsp = new AsmRegister64(ICRegisters.rsp);
        program.sub(rsp, this.size);
        Collections.shuffle(this.slots);
        for (Slot slot : this.slots) {
            slot.setup(program);
        }
    }

    public void done(CodeAssembler program) {
        Collections.shuffle(this.slots);
        for (Slot slot : this.slots) {
            slot.cleanup(program);
        }
        AsmRegister64 rsp = new AsmRegister64(ICRegisters.rsp);
        program.add(rsp, this.size);
    }

    private static class ConstantSlot
    implements Slot {
        protected long value;
        protected AsmMemoryOperand memptr;

        public ConstantSlot(long value, AsmMemoryOperand memptr) {
            this.value = value;
            this.memptr = memptr;
        }

        @Override
        public void setup(CodeAssembler program) {
            AsmRegister64 rax = new AsmRegister64(ICRegisters.rax);
            if (this.value == 0L) {
                program.xor(rax, rax);
                program.mov(this.memptr, rax);
            } else {
                program.mov(rax, this.value);
                program.mov(this.memptr, rax);
            }
        }

        @Override
        public void cleanup(CodeAssembler program) {
        }
    }

    private static class RegSlot
    implements Slot {
        protected AsmRegister64 reg;
        protected AsmMemoryOperand memptr;

        public RegSlot(AsmRegister64 reg, AsmMemoryOperand memptr) {
            this.reg = reg;
            this.memptr = memptr;
        }

        @Override
        public void setup(CodeAssembler program) {
            program.mov(this.memptr, this.reg);
        }

        @Override
        public void cleanup(CodeAssembler program) {
            program.mov(this.reg, this.memptr);
        }
    }

    private static interface Slot {
        public void setup(CodeAssembler var1);

        public void cleanup(CodeAssembler var1);
    }
}

