/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.lttl;

import com.github.icedland.iced.x86.Instruction;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeVisitor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Zones
implements CodeVisitor {
    protected Set danger = new HashSet();
    protected Code analysis;
    protected List zone = new LinkedList();
    protected Set ignore = new HashSet();

    public Zones(Code analysis) {
        this.analysis = analysis;
        this.ignore.add("ADD EAX, imm32");
        this.ignore.add("CMP EAX, imm32");
        this.ignore.add("CMP r/m32, imm32");
        this.ignore.add("CMP r/m8, imm8");
        this.ignore.add("CMP r/m16, imm16");
        this.ignore.add("CMP r/m32, imm32");
        this.ignore.add("CMP r/m64, imm32");
    }

    public boolean isDangerous(Instruction inst) {
        return this.danger.contains(inst.getIP());
    }

    public boolean isSafe(Instruction inst) {
        return this.ignore.contains(inst.getOpCode().toInstructionString());
    }

    @Override
    public void visit(Instruction next) {
        if (next.getRflagsModified() != 0) {
            this.zone = new LinkedList();
        } else if (!next.getRepPrefix() && !next.getRepnePrefix() && next.getRflagsRead() != 0) {
            for (Instruction temp : this.zone) {
                this.danger.add(temp.getIP());
            }
        }
        if (!this.isSafe(next)) {
            this.zone.add(next);
        }
    }
}

