/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.lttl;

import com.github.icedland.iced.x86.ICRegisters;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.Rebuilder;
import crystalpalace.util.CrystalUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class SavedRegContext {
    protected Map prologue = new LinkedHashMap();
    protected Map epilogue = new LinkedHashMap();
    protected Set exclude = new HashSet();
    protected boolean relocs = false;

    public boolean isBookend(Instruction inst) {
        return this.prologue.containsKey(inst.getIP()) || this.epilogue.containsKey(inst.getIP());
    }

    public void dump(String name) {
        if (this.prologue.size() == 0) {
            return;
        }
        CrystalUtils.print_info("Stack info: " + name);
        for (Instruction inst : this.prologue.values()) {
            CodeUtils.p(inst);
        }
        for (Instruction inst : this.epilogue.values()) {
            CodeUtils.p(inst);
        }
        Iterator<Object> i = this.getSwappableRegisters().iterator();
        while (i.hasNext()) {
            CrystalUtils.print_stat("Swappable: " + CodeUtils.getRegString(i.next()));
        }
    }

    protected boolean isNonVolatileReg(int x) {
        return SavedRegContext.toBaseReg(x) != null;
    }

    public static AsmRegister64 toBaseReg(int x) {
        switch (x) {
            case 56: {
                return new AsmRegister64(ICRegisters.rbx);
            }
            case 60: {
                return new AsmRegister64(ICRegisters.rdi);
            }
            case 59: {
                return new AsmRegister64(ICRegisters.rsi);
            }
            case 65: {
                return new AsmRegister64(ICRegisters.r12);
            }
            case 66: {
                return new AsmRegister64(ICRegisters.r13);
            }
            case 67: {
                return new AsmRegister64(ICRegisters.r14);
            }
            case 68: {
                return new AsmRegister64(ICRegisters.r15);
            }
            case 40: {
                return new AsmRegister64(ICRegisters.rbx);
            }
            case 44: {
                return new AsmRegister64(ICRegisters.rdi);
            }
            case 43: {
                return new AsmRegister64(ICRegisters.rsi);
            }
            case 49: {
                return new AsmRegister64(ICRegisters.r12);
            }
            case 50: {
                return new AsmRegister64(ICRegisters.r13);
            }
            case 51: {
                return new AsmRegister64(ICRegisters.r14);
            }
            case 52: {
                return new AsmRegister64(ICRegisters.r15);
            }
            case 24: {
                return new AsmRegister64(ICRegisters.rbx);
            }
            case 28: {
                return new AsmRegister64(ICRegisters.rdi);
            }
            case 27: {
                return new AsmRegister64(ICRegisters.rsi);
            }
            case 33: {
                return new AsmRegister64(ICRegisters.r12);
            }
            case 34: {
                return new AsmRegister64(ICRegisters.r13);
            }
            case 35: {
                return new AsmRegister64(ICRegisters.r14);
            }
            case 36: {
                return new AsmRegister64(ICRegisters.r15);
            }
            case 4: {
                return new AsmRegister64(ICRegisters.rbx);
            }
            case 8: {
                return new AsmRegister64(ICRegisters.rbx);
            }
            case 12: {
                return new AsmRegister64(ICRegisters.rdi);
            }
            case 11: {
                return new AsmRegister64(ICRegisters.rsi);
            }
            case 17: {
                return new AsmRegister64(ICRegisters.r12);
            }
            case 18: {
                return new AsmRegister64(ICRegisters.r13);
            }
            case 19: {
                return new AsmRegister64(ICRegisters.r14);
            }
            case 20: {
                return new AsmRegister64(ICRegisters.r15);
            }
        }
        return null;
    }

    public static int toSize(int x) {
        switch (x) {
            case 56: 
            case 59: 
            case 60: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                return 64;
            }
            case 40: 
            case 43: 
            case 44: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                return 32;
            }
            case 24: 
            case 27: 
            case 28: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return 16;
            }
            case 8: {
                throw new RuntimeException("Can't swap %bh register");
            }
            case 4: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return 8;
            }
        }
        throw new RuntimeException("Invalid reg: " + x);
    }

    public Set getSwappableRegisters() {
        HashSet<AsmRegister64> temp = new HashSet<AsmRegister64>();
        for (Instruction next : this.prologue.values()) {
            if (CodeUtils.is(next, "PUSH r64")) {
                if (!this.isNonVolatileReg(next.getOp0Register())) continue;
                temp.add(SavedRegContext.toBaseReg(next.getOp0Register()));
                continue;
            }
            if (!CodeUtils.is(next, "PUSH r32") || !this.isNonVolatileReg(next.getOp0Register())) continue;
            temp.add(SavedRegContext.toBaseReg(next.getOp0Register()));
        }
        temp.removeAll(this.exclude);
        return temp;
    }

    public Set toString(Set x) {
        HashSet<String> y = new HashSet<String>();
        Iterator i = x.iterator();
        while (i.hasNext()) {
            y.add(CodeUtils.getRegString(i.next()));
        }
        return y;
    }

    public boolean isSane() {
        return this.prologue.size() > 0 && this.prologue.size() == this.epilogue.size() && !this.relocs && this.getSwappableRegisters().size() >= 3;
    }

    protected void a(ListIterator i) {
        while (i.hasNext()) {
            Instruction next = (Instruction)i.next();
            if (CodeUtils.is(next, "PUSH r64")) {
                this.prologue.put(next.getIP(), next);
                continue;
            }
            if (!CodeUtils.is(next, "PUSH r32")) break;
            this.prologue.put(next.getIP(), next);
        }
        this.b(i);
    }

    protected void b(ListIterator i) {
        while (i.hasNext()) {
            Instruction next = (Instruction)i.next();
            if (!CodeUtils.is(next, "RET")) continue;
            this.c(i);
            return;
        }
    }

    protected void c(ListIterator i) {
        i.previous();
        while (i.hasPrevious()) {
            Instruction prev = (Instruction)i.previous();
            if (CodeUtils.is(prev, "POP r64")) {
                this.epilogue.put(prev.getIP(), prev);
                continue;
            }
            if (!CodeUtils.is(prev, "POP r32")) break;
            this.epilogue.put(prev.getIP(), prev);
        }
    }

    protected boolean usesBH(Instruction next) {
        for (int x = 0; x < next.getOpCount(); ++x) {
            if (next.getOpKind(x) != 0 || next.getOpRegister(x) != 8) continue;
            return true;
        }
        if (next.getMemoryBase() == 8) {
            return true;
        }
        return next.getMemoryIndex() == 8;
    }

    protected void findSpecial(Iterator i) {
        while (i.hasNext()) {
            Instruction next = (Instruction)i.next();
            if (next.isStringInstruction()) {
                this.exclude.add(new AsmRegister64(ICRegisters.rdi));
                this.exclude.add(new AsmRegister64(ICRegisters.rsi));
                continue;
            }
            if (CodeUtils.is(next, "CPUID") || CodeUtils.is(next, "CMPXCHG16B") || CodeUtils.is(next, "XLAT") || CodeUtils.is(next, "CMPXCHG8B")) {
                this.exclude.add(new AsmRegister64(ICRegisters.rbx));
                continue;
            }
            if (!this.usesBH(next)) continue;
            this.exclude.add(new AsmRegister64(ICRegisters.rbx));
        }
    }

    protected boolean safeRelocs(Rebuilder builder, Iterator i) {
        while (i.hasNext()) {
            Instruction next = (Instruction)i.next();
            if (!builder.getAnalysis().hasRelocation(next)) continue;
            for (int x = 0; x < next.getOpCount(); ++x) {
                if (next.getOpKind(x) != 0 || !this.isNonVolatileReg(next.getOpRegister(x))) continue;
                return false;
            }
            if (this.isNonVolatileReg(next.getMemoryBase())) {
                return false;
            }
            if (!this.isNonVolatileReg(next.getMemoryIndex())) continue;
            return false;
        }
        return true;
    }

    public SavedRegContext(Rebuilder builder, String func, List instructions) {
        this.a(instructions.listIterator());
        this.findSpecial(instructions.iterator());
        this.relocs = !this.safeRelocs(builder, instructions.iterator());
    }
}

