/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.lttl;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.asm.CodeAssemblerResult;
import com.github.icedland.iced.x86.asm.CodeLabel;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.CodeVisitor;
import crystalpalace.btf.Rebuilder;
import crystalpalace.btf.lttl.Jumps;
import crystalpalace.btf.lttl.RelocationFix;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.Symbol;
import crystalpalace.util.CrystalUtils;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class Relocations {
    protected CodeAssembler program;
    protected Code analysis;
    protected Map relocs = new LinkedHashMap();

    public Relocations(Code analysis, CodeAssembler program) {
        this.analysis = analysis;
        this.program = program;
    }

    public RelocationFix get(Relocation r) {
        return (RelocationFix)this.relocs.get(r);
    }

    public RelocationFix add(Relocation r, CodeLabel label, int offset) {
        RelocationFix fix = new RelocationFix(this.analysis.getObject(), r, label, offset);
        this.relocs.put(r, fix);
        return fix;
    }

    public void resolve(Relocation r) {
        this.relocs.remove(r);
    }

    public void analyze(Rebuilder rebuilder, final Jumps jumps) {
        rebuilder.walk(new CodeVisitor(){

            @Override
            public void visit(Instruction next) {
                Relocation r = Relocations.this.analysis.getRelocation(next);
                if (r == null) {
                    return;
                }
                CodeLabel label = jumps.createLabel(next.getIP());
                long offset = r.getVirtualAddress() - next.getIP();
                RelocationFix fix = Relocations.this.add(r, label, (int)offset);
                if (CodeUtils.is(next, "JMP r/m64")) {
                    fix.instOffset = 2;
                }
            }
        });
    }

    public void rebuild(COFFObject object, CodeAssemblerResult results) {
        LinkedList<Relocation> newrelocs = new LinkedList<Relocation>();
        for (RelocationFix entry : this.relocs.values()) {
            CodeLabel label = entry.getLabel();
            Relocation reloc = entry.getRelocation();
            reloc.setVirtualAddress(results.getLabelRIP(label) + (long)entry.getOffsetFromInstruction());
            if (".text".equals(reloc.getSymbolName())) {
                Symbol temp = this.analysis.getLabel(entry.getRelocOffsetLong());
                if (temp != null) {
                    entry.setRelocOffsetValue(temp.getValue());
                } else {
                    throw new RuntimeException("Could not fix " + entry.toStringOld() + " - no symbol at " + CrystalUtils.toHex(entry.getRelocOffsetLong()) + ". (Modified program will crash)");
                }
            }
            object.getSection(".text").patch((int)reloc.getVirtualAddress(), entry.getRelocOffsetValue());
            newrelocs.add(reloc);
        }
        object.getSection(".text").setRelocations(newrelocs);
    }
}

