/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.lttl;

import com.github.icedland.iced.x86.asm.CodeLabel;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Relocation;
import crystalpalace.util.CrystalUtils;

public class RelocationFix {
    protected Relocation reloc;
    public int instOffset;
    protected byte[] valueAt;
    public CodeLabel label;
    protected String toStrOld;

    public RelocationFix(COFFObject object, Relocation reloc, CodeLabel label, int instOffset) {
        this.reloc = reloc;
        this.label = label;
        this.instOffset = instOffset;
        this.valueAt = object.getSection(".text").fetch((int)reloc.getVirtualAddress(), 4);
        this.toStrOld = reloc.toString();
    }

    public Relocation getRelocation() {
        return this.reloc;
    }

    public CodeLabel getLabel() {
        return this.label;
    }

    public int getOffsetFromInstruction() {
        return this.instOffset;
    }

    public long getRelocOffsetLong() {
        return CrystalUtils.getDWORD(this.valueAt, 0);
    }

    public byte[] getRelocOffsetValue() {
        return this.valueAt;
    }

    public void setRelocOffsetValue(long x) {
        CrystalUtils.putDWORD(this.valueAt, 0, (int)x);
    }

    public String toStringOld() {
        return this.toStrOld;
    }
}

