/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.lttl;

import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.asm.AsmRegisters;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.asm.CodeAssemblerResult;
import com.github.icedland.iced.x86.asm.CodeLabel;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.ResolveLabel;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Symbol;
import java.util.HashMap;
import java.util.Map;

public class LocalLabels {
    protected CodeAssembler program;
    protected Code analysis;
    protected Map labels = new HashMap();

    public LocalLabels(Code analysis, CodeAssembler program) {
        this.analysis = analysis;
        this.program = program;
    }

    public CodeLabel getLabel(String func) {
        return (CodeLabel)this.labels.get(func);
    }

    public void analyze(Map funcs) {
        for (Map.Entry entry : funcs.entrySet()) {
            this.labels.put(entry.getKey(), this.program.createLabel());
        }
    }

    public void startFunction(Map.Entry entry) {
        this.program.label((CodeLabel)this.labels.get(entry.getKey()));
        this.program.zero_bytes();
    }

    public boolean usesLocalLabel(Instruction inst) {
        if (inst.isCallNear()) {
            return true;
        }
        if (inst.isIPRelativeMemoryOperand()) {
            return true;
        }
        if (CodeUtils.is(inst, "JMP rel8") || CodeUtils.is(inst, "JMP rel32")) {
            return this.analysis.getLabel(inst.getMemoryDisplacement32()) != null;
        }
        return false;
    }

    public void process(RebuildStep state, Instruction inst, ResolveLabel lookup) {
        Symbol temp = this.analysis.getLabel(inst.getMemoryDisplacement32());
        if (temp == null) {
            throw new RuntimeException("Can't transform '" + state.getInstructionString() + "'. (Modified program will crash)");
        }
        if (inst.isCallNear()) {
            this.program.addInstruction(Instruction.createBranch(inst.getCode(), lookup.getCodeLabel((RebuildStep)state, (String)temp.getName()).id));
        } else if (CodeUtils.is(inst, "JMP rel8") || CodeUtils.is(inst, "JMP rel32")) {
            this.program.jmp(lookup.getCodeLabel(state, temp.getName()));
        } else if (inst.isIPRelativeMemoryOperand()) {
            if ("LEA r64, m".equals(inst.getOpCode().toInstructionString())) {
                this.program.lea(new AsmRegister64(new ICRegister(inst.getOp0Register())), AsmRegisters.mem_ptr(lookup.getCodeLabel(state, temp.getName())));
            } else if ("MOV r64, r/m64".equals(inst.getOpCode().toInstructionString())) {
                this.program.mov(new AsmRegister64(new ICRegister(inst.getOp0Register())), AsmRegisters.mem_ptr(lookup.getCodeLabel(state, temp.getName())));
            } else if ("CALL r/m64".equals(inst.getOpCode().toInstructionString())) {
                this.program.call(AsmRegisters.qword_ptr(lookup.getCodeLabel(state, temp.getName())));
            } else {
                throw new RuntimeException("Can't transform '" + state.getInstructionString() + "' for " + temp + ". (Modified program will crash)");
            }
        }
    }

    public void rebuild(COFFObject object, CodeAssemblerResult results) {
        for (Symbol temp : object.getSection(".text").getSymbols()) {
            if (!this.labels.containsKey(temp.getName())) continue;
            temp.setValue(results.getLabelRIP((CodeLabel)this.labels.get(temp.getName())));
        }
    }
}

