/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.lttl;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.asm.CodeLabel;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.CodeVisitor;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.ResolveLabel;
import java.util.HashMap;
import java.util.Map;

public class Jumps
implements CodeVisitor {
    protected CodeAssembler program;
    protected Code analysis;
    protected Map targets = new HashMap();
    protected Map jumps = new HashMap();

    public Jumps(Code analysis, CodeAssembler program) {
        this.analysis = analysis;
        this.program = program;
    }

    public boolean hasLabel(Instruction next) {
        return this.targets.containsKey(next.getIP());
    }

    public CodeLabel getLabel(Instruction next) {
        return (CodeLabel)this.targets.get(next.getIP());
    }

    public boolean isJump(Instruction next) {
        return this.jumps.containsKey(next);
    }

    public CodeLabel getJumpLabel(Instruction next) {
        return (CodeLabel)this.jumps.get(next);
    }

    public CodeLabel createLabel(long target) {
        CodeLabel label = null;
        if (this.targets.containsKey(target)) {
            label = (CodeLabel)this.targets.get(target);
        } else {
            label = this.program.createLabel();
            this.targets.put(target, label);
        }
        return label;
    }

    public void add(Instruction inst) {
        CodeLabel label = this.createLabel(inst.getMemoryDisplacement32());
        this.jumps.put(inst, label);
    }

    @Override
    public void visit(Instruction next) {
        if (next.isJccShortOrNear()) {
            this.add(next);
        } else if (!next.isCallNear()) {
            if (next.isJcxShort()) {
                this.add(next);
            } else if (next.isJkccShortOrNear()) {
                this.add(next);
            } else if (next.isJmpFar()) {
                CodeUtils.details(this.analysis, "Jmp FAR", next);
            } else if (next.isJmpShortOrNear()) {
                this.add(next);
            } else if (next.isLoop()) {
                this.add(next);
            } else if (next.isLoopcc()) {
                this.add(next);
            }
        }
    }

    public void handleLabel(Instruction inst) {
        try {
            if (this.hasLabel(inst)) {
                this.program.label(this.getLabel(inst));
            }
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException("Can't label '" + String.format("%016X %s", inst.getIP(), inst.getOpCode().toInstructionString()) + "'. (a label already exists?)");
        }
    }

    public void process(RebuildStep state, Instruction inst, ResolveLabel lookup) {
        Instruction peek;
        if ((CodeUtils.is(inst, "JMP rel8") || CodeUtils.is(inst, "JMP rel32")) && (peek = state.peekNext()) != null && this.hasLabel(peek) && this.getJumpLabel(inst) == this.getLabel(peek)) {
            this.program.zero_bytes();
            return;
        }
        this.program.addInstruction(Instruction.createBranch(inst.getCode(), this.getJumpLabel((Instruction)inst).id));
    }
}

