/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.lttl;

import com.github.icedland.iced.x86.Instruction;
import crystalpalace.btf.Rebuilder;
import crystalpalace.btf.lttl.Blocks;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DirtyLeaves {
    protected Set dirty = new HashSet();

    public void walk(Blocks blocks, String name, List instructions) {
        for (Instruction next : instructions) {
            if (!next.isCallNear() && !next.isCallNearIndirect() && !next.isCallFar() && !next.isCallFarIndirect()) continue;
            return;
        }
        int stackptr = 8;
        for (Instruction next : blocks.getPrologue(name)) {
            if (next.getStackPointerIncrement() >= 0) continue;
            stackptr += next.getStackPointerIncrement();
        }
        if (stackptr % 16 != 0) {
            this.dirty.add(name);
        }
    }

    public boolean isDirty(String name) {
        return this.dirty.contains(name);
    }

    public void analyze(Rebuilder builder, Map funcs) {
        if (!builder.getAnalysis().getObject().x64()) {
            return;
        }
        for (Map.Entry entry : funcs.entrySet()) {
            String name = (String)entry.getKey();
            List instructions = (List)entry.getValue();
            if (!builder.getAnalysis().isFunction(name)) continue;
            this.walk(builder.getBlocks(), name, instructions);
        }
    }
}

