/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf.lttl;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.asm.CodeLabel;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.Rebuilder;
import crystalpalace.btf.lttl.Jumps;
import crystalpalace.util.CrystalUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Blocks {
    protected Map groups = new HashMap();
    protected Map edges = new HashMap();
    protected Jumps jumps = null;
    protected Rebuilder builder = null;

    public Map getEdges() {
        return this.edges;
    }

    public boolean isEdge(Instruction inst) {
        return this.edges.containsKey(inst.getIP());
    }

    public CodeLabel getEdgeTarget(Instruction inst) {
        return (CodeLabel)this.edges.get(inst.getIP());
    }

    public LinkedList getBlocks(String func) {
        return new LinkedList(((BlockGroup)this.groups.get(func)).getBlocks());
    }

    public List getPrologue(String func) {
        LinkedList blocks = this.getBlocks(func);
        if (blocks.size() > 0) {
            return (List)blocks.getFirst();
        }
        return new LinkedList();
    }

    public Map getAllBlocks() {
        HashMap<String, LinkedList> rv = new HashMap<String, LinkedList>();
        for (String key : this.groups.keySet()) {
            rv.put(key, this.getBlocks(key));
        }
        return rv;
    }

    public void dump(String func, Code analysis, List blocks) {
        CrystalUtils.print_good("BEGIN " + func);
        for (List next : blocks) {
            CrystalUtils.print_warn("--- BLOCK ---");
            CodeUtils.print(analysis, next);
        }
        CrystalUtils.print_good("END " + func);
    }

    public void analyze(Rebuilder builder, Map funcs) {
        this.jumps = builder.getJumps();
        this.builder = builder;
        for (Map.Entry entry : funcs.entrySet()) {
            String name = (String)entry.getKey();
            List instructions = (List)entry.getValue();
            if (!builder.getAnalysis().isFunction(name)) continue;
            this.groups.put(name, new BlockGroup(instructions));
        }
    }

    public void finalize(CodeAssembler program, RebuildStep step, Instruction current) {
        if (CodeUtils.is(current, "JMP rel32") || CodeUtils.is(current, "JMP rel8")) {
            return;
        }
        if (!this.isEdge(current)) {
            return;
        }
        Instruction next = step.peekNext();
        if (next != null && this.jumps.getLabel(next) == this.getEdgeTarget(current)) {
            return;
        }
        program.jmp(this.getEdgeTarget(current));
    }

    protected class BlockGroup {
        protected Map blocks = new LinkedHashMap();
        protected LinkedList block = null;
        protected Instruction last = null;

        public void leader(Instruction inst) {
            if (this.last != null) {
                Blocks.this.edges.put(this.last.getIP(), Blocks.this.jumps.createLabel(inst.getIP()));
            }
            this.block = new LinkedList();
            this.add(inst);
            this.blocks.put(inst.getIP(), this.block);
        }

        public void add(Instruction inst) {
            this.last = inst;
            this.block.add(inst);
        }

        public BlockGroup(List instructions) {
            Iterator i = instructions.iterator();
            while (i.hasNext()) {
                Instruction inst = (Instruction)i.next();
                if (this.block == null) {
                    this.leader(inst);
                } else if (Blocks.this.builder.getAnalysis().getRelocation(inst) != null) {
                    this.add(inst);
                } else if (Blocks.this.jumps.hasLabel(inst)) {
                    this.leader(inst);
                } else {
                    this.add(inst);
                }
                if (!Blocks.this.jumps.isJump(inst) || !i.hasNext()) continue;
                inst = (Instruction)i.next();
                this.leader(inst);
            }
        }

        public List getBlocks() {
            return new LinkedList(this.blocks.values());
        }
    }
}

