/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.CodeWriter;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.asm.CodeAssemblerResult;
import crystalpalace.btf.AddInstruction;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeVisitor;
import crystalpalace.btf.FilterCode;
import crystalpalace.btf.RebuildConfig;
import crystalpalace.btf.RebuildStep;
import crystalpalace.btf.ResolveLabel;
import crystalpalace.btf.lttl.Blocks;
import crystalpalace.btf.lttl.DirtyLeaves;
import crystalpalace.btf.lttl.Jumps;
import crystalpalace.btf.lttl.LocalLabels;
import crystalpalace.btf.lttl.Relocations;
import crystalpalace.btf.lttl.Zones;
import crystalpalace.coff.COFFObject;
import java.io.ByteArrayOutputStream;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class Rebuilder {
    protected Code analysis;
    protected Map funcs;
    protected COFFObject object;
    protected CodeAssembler program = null;
    protected CodeAssemblerResult results = null;
    protected RebuildStep state = new RebuildStep(this);
    protected LocalLabels labels = null;
    protected Relocations relocs = null;
    protected Jumps jumps = null;
    protected Zones zones = null;
    protected Blocks blocks = null;
    protected DirtyLeaves leaves = null;

    public Rebuilder(Code analysis, Map funcs) {
        this.analysis = analysis;
        this.funcs = funcs;
        this.object = analysis.getObject();
    }

    public Blocks getBlocks() {
        return this.blocks;
    }

    public Code getAnalysis() {
        return this.analysis;
    }

    public Jumps getJumps() {
        return this.jumps;
    }

    public Relocations getRelocations() {
        return this.relocs;
    }

    public Zones getZones() {
        return this.zones;
    }

    public DirtyLeaves getLeaves() {
        return this.leaves;
    }

    public void walk(CodeVisitor visitor) {
        for (Map.Entry entry : this.funcs.entrySet()) {
            String func = (String)entry.getKey();
            List insts = (List)entry.getValue();
            for (Instruction next : insts) {
                visitor.visit(next);
            }
        }
    }

    public COFFObject rebuild(RebuildConfig config) {
        return this._rebuild(config.getAdder(), config.getLookup(), config.getFilter());
    }

    protected COFFObject _rebuild(AddInstruction adder, ResolveLabel lookup, FilterCode filter) {
        this.program = new CodeAssembler(this.object.getBits());
        this.labels = new LocalLabels(this.analysis, this.program);
        this.relocs = new Relocations(this.analysis, this.program);
        this.jumps = new Jumps(this.analysis, this.program);
        this.zones = new Zones(this.analysis);
        this.blocks = new Blocks();
        this.leaves = new DirtyLeaves();
        this.labels.analyze(this.funcs);
        this.relocs.analyze(this, this.jumps);
        this.walk(this.jumps);
        this.walk(this.zones);
        this.blocks.analyze(this, this.funcs);
        this.leaves.analyze(this, this.funcs);
        for (Map.Entry entry : this.funcs.entrySet()) {
            boolean isFunction = this.analysis.isFunction((String)entry.getKey());
            this.labels.startFunction(entry);
            ListIterator k = null;
            k = isFunction ? filter.filterCode(this, (String)entry.getKey(), (List)entry.getValue()).listIterator() : ((List)entry.getValue()).listIterator();
            this.state.enter((String)entry.getKey(), k);
            while (k.hasNext()) {
                Instruction inst = (Instruction)k.next();
                this.state.step(inst);
                this.jumps.handleLabel(inst);
                Instruction copy = inst.copy();
                copy.setIP(0L);
                if (!isFunction) {
                    this.program.addInstruction(copy);
                } else if (this.analysis.hasRelocation(inst)) {
                    adder.addInstruction(this.program, this.state, copy);
                } else if (this.labels.usesLocalLabel(inst)) {
                    this.labels.process(this.state, inst, lookup);
                } else if (this.jumps.isJump(inst)) {
                    this.jumps.process(this.state, inst, lookup);
                } else {
                    adder.addInstruction(this.program, this.state, copy);
                }
                this.blocks.finalize(this.program, this.state, inst);
            }
        }
        byte[] text_content = this.assemble();
        this.object.getSection(".text").setData(text_content);
        this.labels.rebuild(this.object, this.results);
        this.relocs.rebuild(this.object, this.results);
        return this.object;
    }

    protected byte[] assemble() {
        final ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        Object result = this.program.assemble(new CodeWriter(){

            @Override
            public void writeByte(byte value) {
                out.write(value);
            }
        }, 0L, 4);
        if (result instanceof String) {
            throw new RuntimeException("assemble() failed: " + (String)result);
        }
        this.results = (CodeAssemblerResult)result;
        return out.toByteArray();
    }
}

