/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.asm.CodeAssembler;
import com.github.icedland.iced.x86.asm.CodeLabel;
import crystalpalace.btf.Rebuilder;
import crystalpalace.btf.lttl.RelocationFix;
import crystalpalace.coff.Relocation;
import crystalpalace.coff.Symbol;
import java.util.ListIterator;

public class RebuildStep {
    protected Rebuilder builder;
    protected Instruction instruction;
    protected String function;
    protected ListIterator iterator;

    public RebuildStep(Rebuilder builder) {
        this.builder = builder;
    }

    public void enter(String function, ListIterator iterator) {
        this.function = function;
        this.iterator = iterator;
    }

    public Instruction peekNext() {
        Instruction next = null;
        if (this.iterator.hasNext()) {
            next = (Instruction)this.iterator.next();
            this.iterator.previous();
        }
        return next;
    }

    public void consumeNext() {
        this.iterator.next();
    }

    public boolean isDangerous() {
        return this.builder.getZones().isDangerous(this.instruction);
    }

    public boolean isDirty() {
        return this.builder.getLeaves().isDirty(this.getFunction());
    }

    public void step(Instruction inst) {
        this.instruction = inst;
    }

    public int getInstructionLength() {
        return this.instruction.getLength();
    }

    public String getInstructionString() {
        return String.format("%016X %s", this.instruction.getIP(), this.instruction.getOpCode().toInstructionString());
    }

    public boolean isRelocDisplacement() {
        return this.getRelocOffset() == this.builder.analysis.getOffsets((Instruction)this.instruction).displacementOffset;
    }

    public boolean isRelocImmediate() {
        return this.getRelocOffset() == this.builder.analysis.getOffsets((Instruction)this.instruction).immediateOffset;
    }

    public int getRelocOffset() {
        RelocationFix fix = this.builder.getRelocations().get(this.getRelocation());
        return fix.instOffset;
    }

    public void setRelocOffset(int x) {
        RelocationFix fix = this.builder.getRelocations().get(this.getRelocation());
        fix.instOffset = x;
    }

    public void setRelocOffsetValue(long x) {
        RelocationFix fix = this.builder.getRelocations().get(this.getRelocation());
        fix.setRelocOffsetValue(x);
    }

    public long getRelocOffsetValue() {
        RelocationFix fix = this.builder.getRelocations().get(this.getRelocation());
        return fix.getRelocOffsetLong();
    }

    public void createRelocationFor(CodeAssembler program, Symbol value, int instOffset) {
        CodeLabel label = program.createLabel();
        program.label(label);
        Relocation reloc = new Relocation(this.builder.object.getSection(".text"), 0L, ".text", 6);
        RelocationFix fix = this.builder.getRelocations().add(reloc, label, instOffset);
        fix.setRelocOffsetValue(value.getValue());
    }

    public void createLabel(CodeAssembler program) {
        CodeLabel label = program.createLabel();
        program.label(label);
        RelocationFix fix = this.builder.getRelocations().get(this.getRelocation());
        fix.label = label;
    }

    public Relocation getRelocation() {
        return this.builder.analysis.getRelocation(this.instruction);
    }

    public boolean hasRelocation() {
        return this.builder.analysis.hasRelocation(this.instruction);
    }

    public void resolve() {
        this.builder.getRelocations().resolve(this.getRelocation());
    }

    public String getFunction() {
        return this.function;
    }

    public CodeLabel getLabel(String func) {
        return this.builder.labels.getLabel(func);
    }
}

