/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import crystalpalace.btf.Code;
import crystalpalace.btf.CodeUtils;
import crystalpalace.btf.RebuildConfig;
import crystalpalace.btf.Rebuilder;
import crystalpalace.btf.pass.MultiModify;
import crystalpalace.btf.pass.easypic.DangerWalk;
import crystalpalace.btf.pass.easypic.FixBSSReferencesX64;
import crystalpalace.btf.pass.easypic.FixBSSReferencesX86;
import crystalpalace.btf.pass.easypic.FixX86References;
import crystalpalace.btf.pass.easypic.ResolveAPI;
import crystalpalace.btf.pass.hook.Attach;
import crystalpalace.btf.pass.hook.Redirect;
import crystalpalace.btf.pass.hook.ResolveHooks;
import crystalpalace.btf.pass.hook.ResolveTags;
import crystalpalace.btf.pass.mutate.BlockParty;
import crystalpalace.btf.pass.mutate.FunctionDisco;
import crystalpalace.btf.pass.mutate.GoFirst;
import crystalpalace.btf.pass.mutate.LinkTimeOptimizer;
import crystalpalace.btf.pass.mutate.Mutator;
import crystalpalace.btf.pass.mutate.RegDance;
import crystalpalace.btf.pass.mutate.Shatter;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.COFFParser;
import crystalpalace.export.DFR;
import crystalpalace.export.ExportInfo;
import crystalpalace.export.Exports;
import crystalpalace.export.Hooks;
import crystalpalace.merge.COFFMerge;
import crystalpalace.util.CrystalUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Modify {
    protected COFFObject object;

    public Modify(COFFObject object) {
        this.object = object;
    }

    public boolean hasIntrinsics() {
        if (this.object.getSymbol("__resolve_hook") != null || this.object.getSymbol("___resolve_hook") != null) {
            return true;
        }
        for (String next : this.object.getSymbols().keySet()) {
            if (!next.startsWith("__tag_") && !next.startsWith("___tag_")) continue;
            return true;
        }
        return false;
    }

    protected COFFObject resolveIntrinsics(Exports exports, Hooks hooks) {
        if (!this.hasIntrinsics()) {
            return this.object;
        }
        Code code = Code.Init(this.object).analyze();
        Map funcs = code.getCodeByFunction();
        MultiModify pass = new MultiModify();
        pass.add(new ResolveHooks(code, hooks));
        pass.add(new ResolveTags(code, exports));
        return new Rebuilder(code, funcs).rebuild(new RebuildConfig().adder(pass));
    }

    protected COFFObject applyWin32Hooks(Hooks hooks) {
        if (!hooks.hasHooks()) {
            return this.object;
        }
        Code code = Code.Init(this.object).analyze();
        Map funcs = code.getCodeByFunction();
        return new Rebuilder(code, funcs).rebuild(new RebuildConfig().adder(new Attach(code, hooks)));
    }

    protected COFFObject applyLocalHooks(Hooks hooks) {
        if (!hooks.hasLocalHooks()) {
            return this.object;
        }
        Code code = Code.Init(this.object).analyze();
        Map funcs = code.getCodeByFunction();
        Redirect redir = new Redirect(code, hooks);
        return new Rebuilder(code, funcs).rebuild(new RebuildConfig().adder(redir).lookup(redir));
    }

    public COFFObject applyHooks(Exports exports, Hooks hooks) {
        this.object = this.resolveIntrinsics(exports, hooks);
        this.object = this.applyLocalHooks(hooks);
        this.object = this.applyWin32Hooks(hooks);
        return this.object;
    }

    public COFFObject fixPIC(DFR resolvers, String retaddr, String getbss) {
        if (!resolvers.hasResolvers() && retaddr == null && getbss == null) {
            return this.object;
        }
        Code code = Code.Init(this.object).analyze();
        Map funcs = code.getCodeByFunction();
        for (String next : resolvers.getResolverFunctions()) {
            new DangerWalk(code, next).apply(funcs);
        }
        if (getbss != null) {
            new DangerWalk(code, getbss).apply(funcs);
        }
        if (retaddr != null) {
            new DangerWalk(code, retaddr).apply(funcs);
        }
        MultiModify pass = new MultiModify();
        if (resolvers.hasResolvers()) {
            pass.add(new ResolveAPI(code, resolvers));
        }
        if (getbss != null) {
            pass.add("x64".equals(this.object.getMachine()) ? new FixBSSReferencesX64(code, getbss) : new FixBSSReferencesX86(code, getbss));
        }
        if (retaddr != null) {
            pass.add(new FixX86References(code, retaddr));
        }
        return new Rebuilder(code, funcs).rebuild(new RebuildConfig().adder(pass));
    }

    public COFFObject mutate(boolean preserveFirst, ExportInfo exports, Set options) {
        if (options.size() == 0) {
            return this.object;
        }
        this.object = this.mutate_pass1(preserveFirst, exports, options);
        this.object = this.mutate_pass2(preserveFirst, exports, options);
        return this.object;
    }

    public COFFObject mutate_pass1(boolean preserveFirst, ExportInfo exports, Set options) {
        Code code = Code.Init(this.object).analyze();
        Map funcs = code.getCodeByFunction();
        if (options.contains("+gofirst")) {
            funcs = new GoFirst(code).apply(funcs);
        }
        if (options.contains("+optimize")) {
            funcs = new LinkTimeOptimizer(code).apply(exports, funcs);
        }
        if (options.contains("+disco")) {
            funcs = new FunctionDisco(code).apply(preserveFirst, funcs);
        }
        RebuildConfig config = new RebuildConfig();
        if (options.contains("+mutate")) {
            config.adder(new Mutator(code));
        }
        if (options.contains("+regdance")) {
            config.filter(new RegDance());
        }
        return new Rebuilder(code, funcs).rebuild(config);
    }

    public COFFObject mutate_pass2(boolean preserveFirst, ExportInfo exports, Set options) {
        Code code = Code.Init(this.object).analyze();
        Map funcs = code.getCodeByFunction();
        RebuildConfig config = new RebuildConfig();
        if (options.contains("+shatter")) {
            config.filter(new Shatter());
        } else if (options.contains("+blockparty")) {
            config.filter(new BlockParty());
        }
        return new Rebuilder(code, funcs).rebuild(config);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            CrystalUtils.print_error("./disassemble [+mutate,+optimize,+disco,+gofirst,+blockparty,+shatter] </path/to/file.o>");
            return;
        }
        COFFObject obj = null;
        String opts = "";
        try {
            if (args.length == 1) {
                obj = new COFFParser().parse(CrystalUtils.readFromFile(args[0])).getObject();
            } else if (args.length == 2) {
                opts = args[0];
                obj = new COFFParser().parse(CrystalUtils.readFromFile(args[1])).getObject();
            }
            COFFMerge merge = new COFFMerge();
            merge.merge(obj);
            merge.finish();
            obj = merge.getObject();
            obj = new Modify(obj).mutate(false, new MockExports(), "".equals(opts) ? new HashSet() : CrystalUtils.toSet(opts));
            CodeUtils.print(Code.Init(obj).analyze());
        }
        catch (Exception ex) {
            CrystalUtils.handleException(ex);
        }
    }

    private static class MockExports
    implements ExportInfo {
        @Override
        public Iterator iterator() {
            return new HashMap().entrySet().iterator();
        }
    }
}

