/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.dec.ByteArrayCodeReader;
import com.github.icedland.iced.x86.dec.Decoder;
import com.github.icedland.iced.x86.fmt.SymbolResult;
import crystalpalace.btf.Code;
import crystalpalace.btf.CodeUtils;
import crystalpalace.coff.COFFObject;
import crystalpalace.coff.Relocation;
import java.util.LinkedList;
import java.util.List;

public class CodeX64
extends Code {
    public CodeX64(COFFObject o) {
        super(o);
    }

    @Override
    public List disassemble() {
        ByteArrayCodeReader codeReader = new ByteArrayCodeReader(this.code);
        Decoder decoder = new Decoder(this.object.getBits(), codeReader);
        decoder.setIP(this.startip);
        long endRip = decoder.getIP() + (long)this.code.length;
        LinkedList<Instruction> instructions = new LinkedList<Instruction>();
        while (decoder.getIP() < endRip) {
            Instruction instr = decoder.decode();
            ConstantOffsets _offsets = decoder.getConstantOffsets(instr);
            if (_offsets.hasDisplacement()) {
                this.offsets.put(instr, _offsets);
            } else if ("CALL rel32".equals(instr.getOpCode().toInstructionString()) && _offsets.hasImmediate()) {
                this.offsets.put(instr, _offsets);
            }
            instructions.add(instr);
        }
        return instructions;
    }

    @Override
    public SymbolResult relocationToSymbol(Relocation reloc, int operand, long address) {
        return new SymbolResult(reloc.getVirtualAddress() + (long)reloc.getFromOffset(), reloc.getSymbolName());
    }

    @Override
    public Relocation getRelocation(Instruction instr) {
        if (this.hasOffsets(instr)) {
            return (Relocation)this.relocs.get(this.getRelocationAddress(instr));
        }
        return null;
    }

    private long getRelocationAddress(Instruction instr) {
        ConstantOffsets offsets = this.getOffsets(instr);
        if (offsets != null) {
            if (offsets.hasDisplacement()) {
                return instr.getIP() + (long)offsets.displacementOffset;
            }
            if (offsets.hasImmediate()) {
                return instr.getIP() + (long)offsets.immediateOffset;
            }
            throw new RuntimeException("getRelocationAddress('" + CodeUtils.toString(instr) + "') arg has offsets but not displ/immed.");
        }
        throw new RuntimeException("getRelocationAddress('" + CodeUtils.toString(instr) + "') arg has no displacement");
    }
}

