/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.FpuStackIncrementInfo;
import com.github.icedland.iced.x86.ICRegister;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.MemorySize;
import com.github.icedland.iced.x86.asm.AsmRegister32;
import com.github.icedland.iced.x86.asm.AsmRegister64;
import com.github.icedland.iced.x86.fmt.StringOutput;
import com.github.icedland.iced.x86.fmt.SymbolResolver;
import com.github.icedland.iced.x86.fmt.SymbolResult;
import com.github.icedland.iced.x86.fmt.gas.GasFormatter;
import com.github.icedland.iced.x86.info.InstructionInfo;
import com.github.icedland.iced.x86.info.InstructionInfoFactory;
import com.github.icedland.iced.x86.info.OpCodeInfo;
import crystalpalace.btf.Code;
import crystalpalace.btf.RebuildStep;
import crystalpalace.coff.Relocation;
import crystalpalace.util.CrystalUtils;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;

public class CodeUtils {
    private static final int HEXBYTES_COLUMN_BYTE_LENGTH = 10;

    public static void details(Code code, String msg, Instruction instr) {
        CrystalUtils.print_stat(msg + ":");
        System.out.println(instr.getOpCode().toInstructionString());
        CodeUtils.printInst(code, instr);
        CodeUtils.dump(instr);
        System.out.println("---");
    }

    public static String toString(Instruction instr) {
        return String.format("%016X %s", instr.getIP(), instr.getOpCode().toInstructionString());
    }

    public static boolean is(Instruction instr, String form) {
        return instr.getOpCode().toInstructionString().equals(form);
    }

    public static String f(Instruction instr) {
        GasFormatter formatter = new GasFormatter();
        formatter.getOptions().setDigitSeparator("`");
        formatter.getOptions().setFirstOperandCharIndex(10);
        formatter.getOptions().setGasSpaceAfterMemoryOperandComma(true);
        StringOutput output = new StringOutput();
        formatter.format(instr, output);
        return String.format("%016X %-32s %-20s", instr.getIP(), instr.getOpCode().toInstructionString(), output);
    }

    public static void p(Instruction instr) {
        CrystalUtils.print_warn(CodeUtils.f(instr));
    }

    public static void p(RebuildStep step) {
        if (step.hasRelocation()) {
            CrystalUtils.print_warn(CodeUtils.f(step.instruction) + " (" + step.getFunction() + ")\n\t" + step.getRelocation());
        } else {
            CrystalUtils.print_warn(CodeUtils.f(step.instruction) + " (" + step.getFunction() + ")");
        }
    }

    public static String getRegString(AsmRegister32 reg) {
        return CodeUtils.getRegString(reg.get());
    }

    public static String getRegString(AsmRegister64 reg) {
        return CodeUtils.getRegString(reg.get());
    }

    public static String getRegString(ICRegister reg) {
        return CodeUtils.getRegString(reg.get());
    }

    public static String getRegString(Object reg) {
        if (reg == null) {
            return "<null>";
        }
        if (reg instanceof AsmRegister32) {
            return CodeUtils.getRegString((AsmRegister32)reg);
        }
        if (reg instanceof AsmRegister64) {
            return CodeUtils.getRegString((AsmRegister64)reg);
        }
        if (reg instanceof ICRegister) {
            return CodeUtils.getRegString((ICRegister)reg);
        }
        return "getRegString? " + reg.getClass();
    }

    public static String getRegString(int reg) {
        switch (reg) {
            case 53: {
                return "%rax";
            }
            case 54: {
                return "%rcx";
            }
            case 55: {
                return "%rdx";
            }
            case 56: {
                return "%rbx";
            }
            case 59: {
                return "%rsi";
            }
            case 60: {
                return "%rdi";
            }
            case 57: {
                return "%rsp";
            }
            case 58: {
                return "%rbp";
            }
            case 70: {
                return "%rip";
            }
            case 61: {
                return "%r8";
            }
            case 62: {
                return "%r9";
            }
            case 63: {
                return "%r10";
            }
            case 64: {
                return "%r11";
            }
            case 65: {
                return "%r12";
            }
            case 66: {
                return "%r13";
            }
            case 67: {
                return "%r14";
            }
            case 68: {
                return "%r15";
            }
            case 37: {
                return "%eax";
            }
            case 38: {
                return "%ecx";
            }
            case 39: {
                return "%edx";
            }
            case 40: {
                return "%ebx";
            }
            case 43: {
                return "%esi";
            }
            case 44: {
                return "%edi";
            }
            case 41: {
                return "%esp";
            }
            case 42: {
                return "%ebp";
            }
            case 69: {
                return "%eip";
            }
            case 45: {
                return "%r8d";
            }
            case 46: {
                return "%r9d";
            }
            case 47: {
                return "%r10d";
            }
            case 48: {
                return "%r11d";
            }
            case 49: {
                return "%r12d";
            }
            case 50: {
                return "%r13d";
            }
            case 51: {
                return "%r14d";
            }
            case 52: {
                return "%r15d";
            }
            case 21: {
                return "%ax";
            }
            case 22: {
                return "%cx";
            }
            case 23: {
                return "%dx";
            }
            case 24: {
                return "%bx";
            }
            case 27: {
                return "%si";
            }
            case 28: {
                return "%di";
            }
            case 25: {
                return "%sp";
            }
            case 26: {
                return "%bp";
            }
            case 29: {
                return "%r8w";
            }
            case 30: {
                return "%r9w";
            }
            case 31: {
                return "%r10w";
            }
            case 32: {
                return "%r11w";
            }
            case 33: {
                return "%r12w";
            }
            case 34: {
                return "%r13w";
            }
            case 35: {
                return "%r14w";
            }
            case 36: {
                return "%r15w";
            }
            case 0: {
                return "NONE";
            }
        }
        return "Uknown_" + reg;
    }

    public static void dump(Instruction instr) {
        InstructionInfoFactory instrInfoFactory = new InstructionInfoFactory();
        System.out.println(String.format("%016X %s", instr.getIP(), instr));
        OpCodeInfo opCode = instr.getOpCode();
        InstructionInfo info = instrInfoFactory.getInfo(instr);
        FpuStackIncrementInfo fpuInfo = instr.getFpuStackIncrementInfo();
        System.out.println(String.format("    OpCode: %s", opCode.toOpCodeString()));
        System.out.println(String.format("    Instruction: %s", opCode.toInstructionString()));
        if (instr.isStackInstruction()) {
            System.out.println(String.format("    SP Increment: %d", instr.getStackPointerIncrement()));
        }
        for (int i = 0; i < instr.getOpCount(); ++i) {
            int opKind = instr.getOpKind(i);
            if (opKind == 24) {
                int size = MemorySize.getSize(instr.getMemorySize());
                if (size == 0) break;
                System.out.println(String.format("    Memory size: %d", size));
                break;
            }
            if (opKind != 0) continue;
            System.out.println("Op " + i + " is a register");
        }
    }

    public static void printInst(Code code, Instruction inst) {
        LinkedList<Instruction> temp = new LinkedList<Instruction>();
        temp.add(inst);
        CodeUtils.print(code, temp);
    }

    public static void print(Code code, List instructions) {
        CodeUtils.print(System.out, code, instructions);
    }

    public static void print(PrintStream out, Code code) {
        CodeUtils.print(out, code, code.getCode());
    }

    public static void print(PrintStream out, final Code code, List instructions) {
        SymbolResolver symResolver = new SymbolResolver(){

            @Override
            public SymbolResult getSymbol(Instruction instruction, int operand, int instructionOperand, long address, int addressSize) {
                Relocation reloc = code.getRelocation(instruction);
                if (reloc != null) {
                    return code.relocationToSymbol(reloc, operand, address);
                }
                if ("CALL rel32".equals(instruction.getOpCode().toInstructionString()) ? code.getLabel(address) != null : instruction.isIPRelativeMemoryOperand() && ("LEA r64, m".equals(instruction.getOpCode().toInstructionString()) ? code.getLabel(address) != null : ("MOV r64, r/m64".equals(instruction.getOpCode().toInstructionString()) ? code.getLabel(address) != null : "CALL r/m64".equals(instruction.getOpCode().toInstructionString()) && code.getLabel(address) != null))) {
                    return new SymbolResult(address, code.getLabel(address).getName());
                }
                return null;
            }
        };
        GasFormatter formatter = new GasFormatter(symResolver);
        formatter.getOptions().setDigitSeparator("`");
        formatter.getOptions().setFirstOperandCharIndex(10);
        formatter.getOptions().setGasSpaceAfterMemoryOperandComma(true);
        StringOutput output = new StringOutput();
        for (Instruction instr : instructions) {
            if (code.getLabel(instr.getIP()) != null) {
                out.println("");
                out.println(String.format("%016X", instr.getIP()) + " <" + code.getLabel(instr.getIP()).getName() + ">:");
            }
            formatter.format(instr, output);
            out.print(String.format("%016X", instr.getIP()));
            out.print(" ");
            int instrLen = instr.getLength();
            int byteBaseIndex = (int)(instr.getIP() - 0L);
            for (int i = 0; i < instrLen; ++i) {
                out.print(String.format("%02X", code.getCodeAsBytes()[byteBaseIndex + i]));
            }
            int missingBytes = 10 - instrLen;
            for (int i = 0; i < missingBytes; ++i) {
                out.print("  ");
            }
            out.print(" ");
            out.println(output.toStringAndReset());
        }
    }

    public static void print(Code code) {
        CodeUtils.print(code, code.getCode());
    }
}

