/*
 * Decompiled with CFR 0.152.
 */
package crystalpalace.btf;

import com.github.icedland.iced.x86.ConditionCode;
import com.github.icedland.iced.x86.ConstantOffsets;
import com.github.icedland.iced.x86.CpuidFeature;
import com.github.icedland.iced.x86.EncodingKind;
import com.github.icedland.iced.x86.FlowControl;
import com.github.icedland.iced.x86.FpuStackIncrementInfo;
import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.MemorySize;
import com.github.icedland.iced.x86.Mnemonic;
import com.github.icedland.iced.x86.Register;
import com.github.icedland.iced.x86.info.InstructionInfo;
import com.github.icedland.iced.x86.info.InstructionInfoFactory;
import com.github.icedland.iced.x86.info.OpAccess;
import com.github.icedland.iced.x86.info.OpCodeInfo;
import com.github.icedland.iced.x86.info.OpCodeOperandKind;
import com.github.icedland.iced.x86.info.UsedMemory;
import com.github.icedland.iced.x86.info.UsedRegister;
import crystalpalace.btf.Code;
import java.lang.reflect.Field;
import java.util.HashMap;

public class CodeInfo {
    static final HashMap<Integer, String> encodingMap = CodeInfo.createHashMap(EncodingKind.class);
    static final HashMap<Integer, String> mnemonicMap = CodeInfo.createHashMap(Mnemonic.class);
    static final HashMap<Integer, String> codeMap = CodeInfo.createHashMap(Code.class);
    static final HashMap<Integer, String> cpuidFeatureMap = CodeInfo.createHashMap(CpuidFeature.class);
    static final HashMap<Integer, String> flowControlMap = CodeInfo.createHashMap(FlowControl.class);
    static final HashMap<Integer, String> opAccessMap = CodeInfo.createHashMap(OpAccess.class);
    static final HashMap<Integer, String> opCodeOperandKindMap = CodeInfo.createHashMap(OpCodeOperandKind.class);
    static final HashMap<Integer, String> conditionCodeMap = CodeInfo.createHashMap(ConditionCode.class);
    static final HashMap<Integer, String> registerMap = CodeInfo.createHashMap(Register.class);
    static final HashMap<Integer, String> memorySizeMap = CodeInfo.createHashMap(MemorySize.class);

    public static void Dump(Instruction instr, ConstantOffsets offsets) {
        int i;
        InstructionInfoFactory instrInfoFactory = new InstructionInfoFactory();
        OpCodeInfo opCode = instr.getOpCode();
        InstructionInfo info = instrInfoFactory.getInfo(instr);
        FpuStackIncrementInfo fpuInfo = instr.getFpuStackIncrementInfo();
        System.out.println(String.format("    OpCode: %s", opCode.toOpCodeString()));
        System.out.println(String.format("    Instruction: %s", opCode.toInstructionString()));
        System.out.println(String.format("    Encoding: %s", CodeInfo.toEncoding(instr.getEncoding())));
        System.out.println(String.format("    Mnemonic: %s", CodeInfo.toMnemonic(instr.getMnemonic())));
        System.out.println(String.format("    Code: %s", CodeInfo.toCode(instr.getCode())));
        System.out.println(String.format("    CpuidFeature: %s", CodeInfo.toCpuidFeatures(instr.getCpuidFeatures())));
        System.out.println(String.format("    FlowControl: %s", CodeInfo.toFlowControl(instr.getFlowControl())));
        if (fpuInfo.writesTop) {
            if (fpuInfo.increment == 0) {
                System.out.println("    FPU TOP: the instruction overwrites TOP");
            } else {
                System.out.println(String.format("    FPU TOP inc: %d", fpuInfo.increment));
            }
            System.out.println(String.format("    FPU TOP cond write: %s", fpuInfo.conditional ? "true" : "false"));
        }
        if (offsets != null) {
            if (offsets.hasDisplacement()) {
                System.out.println(String.format("    Displacement offset = %d, size = %d", offsets.displacementOffset, offsets.displacementSize));
            }
            if (offsets.hasImmediate()) {
                System.out.println(String.format("    Immediate offset = %d, size = %d", offsets.immediateOffset, offsets.immediateSize));
            }
            if (offsets.hasImmediate2()) {
                System.out.println(String.format("    Immediate #2 offset = %d, size = %d", offsets.immediateOffset2, offsets.immediateSize2));
            }
        }
        if (instr.isStackInstruction()) {
            System.out.println(String.format("    SP Increment: %d", instr.getStackPointerIncrement()));
        }
        if (instr.getConditionCode() != 0) {
            System.out.println(String.format("    Condition code: %s", CodeInfo.toConditionCode(instr.getConditionCode())));
        }
        if (instr.getRflagsRead() != 0) {
            System.out.println(String.format("    RFLAGS Read: %s", CodeInfo.toRflagsBits(instr.getRflagsRead())));
        }
        if (instr.getRflagsWritten() != 0) {
            System.out.println(String.format("    RFLAGS Written: %s", CodeInfo.toRflagsBits(instr.getRflagsWritten())));
        }
        if (instr.getRflagsCleared() != 0) {
            System.out.println(String.format("    RFLAGS Cleared: %s", CodeInfo.toRflagsBits(instr.getRflagsCleared())));
        }
        if (instr.getRflagsSet() != 0) {
            System.out.println(String.format("    RFLAGS Set: %s", CodeInfo.toRflagsBits(instr.getRflagsSet())));
        }
        if (instr.getRflagsUndefined() != 0) {
            System.out.println(String.format("    RFLAGS Undefined: %s", CodeInfo.toRflagsBits(instr.getRflagsUndefined())));
        }
        if (instr.getRflagsModified() != 0) {
            System.out.println(String.format("    RFLAGS Modified: %s", CodeInfo.toRflagsBits(instr.getRflagsModified())));
        }
        for (i = 0; i < instr.getOpCount(); ++i) {
            int opKind = instr.getOpKind(i);
            if (opKind != 24) continue;
            int size = MemorySize.getSize(instr.getMemorySize());
            if (size == 0) break;
            System.out.println(String.format("    Memory size: %d", size));
            break;
        }
        for (i = 0; i < instr.getOpCount(); ++i) {
            System.out.println(String.format("    Op%dAccess: %s", i, CodeInfo.toOpAccess(info.getOpAccess(i))));
        }
        for (i = 0; i < opCode.getOpCount(); ++i) {
            System.out.println(String.format("    Op%d: %s", i, CodeInfo.toOpCodeOperandKind(opCode.getOpKind(i))));
        }
        for (UsedRegister regInfo : info.getUsedRegisters()) {
            System.out.println(String.format("    Used reg: %s", CodeInfo.toUsedRegister(regInfo)));
        }
        for (UsedMemory memInfo : info.getUsedMemory()) {
            System.out.println(String.format("    Used mem: %s", CodeInfo.toUsedMemory(memInfo)));
        }
    }

    static HashMap<Integer, String> createHashMap(Class cls) {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (Field field : cls.getDeclaredFields()) {
            if ((field.getModifiers() & 0x10) == 0 || (field.getModifiers() & 8) == 0) continue;
            try {
                result.put(field.getInt(null), field.getName());
            }
            catch (IllegalAccessException ex) {
                throw new UnsupportedOperationException(ex);
            }
        }
        return result;
    }

    static String getMapValue(HashMap<Integer, String> map, int value) {
        String name = map.get(value);
        if (name != null) {
            return name;
        }
        return String.format("0x%X", value);
    }

    static String toEncoding(int value) {
        return CodeInfo.getMapValue(encodingMap, value);
    }

    static String toMnemonic(int value) {
        return CodeInfo.getMapValue(mnemonicMap, value);
    }

    static String toCode(int value) {
        return CodeInfo.getMapValue(codeMap, value);
    }

    static String toCpuidFeature(int value) {
        return CodeInfo.getMapValue(cpuidFeatureMap, value);
    }

    static String toFlowControl(int value) {
        return CodeInfo.getMapValue(flowControlMap, value);
    }

    static String toConditionCode(int value) {
        return CodeInfo.getMapValue(conditionCodeMap, value);
    }

    static String toOpAccess(int value) {
        return CodeInfo.getMapValue(opAccessMap, value);
    }

    static String toOpCodeOperandKind(int value) {
        return CodeInfo.getMapValue(opCodeOperandKindMap, value);
    }

    static String toRegister(int value) {
        return CodeInfo.getMapValue(registerMap, value);
    }

    static String toMemorySize(int value) {
        return CodeInfo.getMapValue(memorySizeMap, value);
    }

    static String toCpuidFeatures(int[] cpuidFeatures) {
        StringBuilder sb = new StringBuilder();
        for (int cpuidFeature : cpuidFeatures) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(CodeInfo.toCpuidFeature(cpuidFeature));
        }
        return sb.toString();
    }

    static int addBit(StringBuilder sb, int value, int flag, String name) {
        if ((value & flag) != 0) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(name);
            value &= ~flag;
        }
        return value;
    }

    static String toRflagsBits(int value) {
        StringBuilder sb = new StringBuilder();
        value = CodeInfo.addBit(sb, value, 1, "OF");
        value = CodeInfo.addBit(sb, value, 2, "SF");
        value = CodeInfo.addBit(sb, value, 4, "ZF");
        value = CodeInfo.addBit(sb, value, 8, "AF");
        value = CodeInfo.addBit(sb, value, 16, "CF");
        value = CodeInfo.addBit(sb, value, 32, "PF");
        value = CodeInfo.addBit(sb, value, 64, "DF");
        value = CodeInfo.addBit(sb, value, 128, "IF");
        value = CodeInfo.addBit(sb, value, 256, "AC");
        value = CodeInfo.addBit(sb, value, 512, "UIF");
        value = CodeInfo.addBit(sb, value, 1024, "C0");
        value = CodeInfo.addBit(sb, value, 2048, "C1");
        value = CodeInfo.addBit(sb, value, 4096, "C2");
        if ((value = CodeInfo.addBit(sb, value, 8192, "C3")) != 0) {
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(String.format("0x%X", value));
        }
        return sb.toString();
    }

    static String toUsedRegister(UsedRegister reg) {
        return CodeInfo.toRegister(reg.getRegister()) + ":" + CodeInfo.toOpAccess(reg.getAccess());
    }

    static String toUsedMemory(UsedMemory mem) {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(CodeInfo.toRegister(mem.getSegment()));
        sb.append(':');
        boolean needPlus = false;
        if (mem.getBase() != 0) {
            sb.append(CodeInfo.toRegister(mem.getBase()));
            needPlus = true;
        }
        if (mem.getIndex() != 0) {
            if (needPlus) {
                sb.append('+');
            }
            needPlus = true;
            sb.append(CodeInfo.toRegister(mem.getIndex()));
            if (mem.getScale() != 1) {
                sb.append('*');
                sb.append((char)(48 + mem.getScale()));
            }
        }
        if (mem.getDisplacement() != 0L || !needPlus) {
            if (needPlus) {
                sb.append('+');
            }
            sb.append("0x");
            sb.append(String.format("%X", mem.getDisplacement()));
        }
        sb.append(';');
        sb.append(CodeInfo.toMemorySize(mem.getMemorySize()));
        sb.append(';');
        sb.append(CodeInfo.toOpAccess(mem.getAccess()));
        sb.append(']');
        return sb.toString();
    }
}

