/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.nasm;

import com.github.icedland.iced.x86.fmt.nasm.InstrInfo;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_AamAad;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_DeclareData;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_OpSize;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_OpSize2_bnd;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_OpSize3;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_Reg16;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_Reg32;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_STIG1;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_STIG2;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_SignExt;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_String;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_XLAT;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_as;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_bcst;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_bnd;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_cc;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_er;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_far;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_far_mem;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_imul;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_invlpga;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_maskmovq;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_movabs;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_nop;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_os;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_os_call;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_os_jcc;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_os_loop;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_os_mem;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_os_mem2;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_os_mem_reg16;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_pblendvb;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_pclmulqdq;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_pops;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_push_imm;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_push_imm8;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_reverse;
import com.github.icedland.iced.x86.fmt.nasm.SimpleInstrInfo_sae;
import com.github.icedland.iced.x86.internal.DataReader;
import com.github.icedland.iced.x86.internal.ResourceReader;
import com.github.icedland.iced.x86.internal.fmt.FormatterConstants;
import com.github.icedland.iced.x86.internal.fmt.FormatterStringsTable;

final class InstrInfos {
    static final InstrInfo[] allInfos = InstrInfos.readInfos();

    InstrInfos() {
    }

    private static byte[] getSerializedInstrInfos() {
        return ResourceReader.readByteArray(InstrInfos.class.getClassLoader(), "com/github/icedland/iced/x86/fmt/nasm/InstrInfos.bin");
    }

    private static String addSuffix(String s, char[] ca) {
        return (s + new String(ca)).intern();
    }

    private static String addPrefix(String s, char[] ca) {
        return (new String(ca) + s).intern();
    }

    private static InstrInfo[] readInfos() {
        DataReader reader = new DataReader(InstrInfos.getSerializedInstrInfos());
        InstrInfo[] infos = new InstrInfo[4936];
        String[] strings = FormatterStringsTable.getStringsTable();
        char[] ca = new char[1];
        int prevIndex = -1;
        for (int i = 0; i < infos.length; ++i) {
            InstrInfo instrInfo;
            int currentIndex;
            byte f = (byte)reader.readByte();
            byte ctorKind = (byte)(f & 0x7F);
            if (ctorKind == 0) {
                currentIndex = reader.getIndex();
                reader.setIndex(prevIndex);
                ctorKind = (byte)(reader.readByte() & 0x7F);
            } else {
                currentIndex = -1;
                prevIndex = reader.getIndex() - 1;
            }
            String s = strings[reader.readCompressedUInt32()];
            if ((f & 0x80) != 0) {
                ca[0] = 118;
                s = InstrInfos.addPrefix(s, ca);
            }
            switch (ctorKind) {
                case 1: {
                    instrInfo = new SimpleInstrInfo(s);
                    break;
                }
                case 2: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo(s, v);
                    break;
                }
                case 3: {
                    instrInfo = new SimpleInstrInfo_AamAad(s);
                    break;
                }
                case 4: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_as(v, s);
                    break;
                }
                case 5: {
                    instrInfo = new SimpleInstrInfo_String(s);
                    break;
                }
                case 7: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_bcst(s, v);
                    break;
                }
                case 8: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_bnd(s, v);
                    break;
                }
                case 10: {
                    instrInfo = new SimpleInstrInfo_DeclareData(i, s);
                    break;
                }
                case 12: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_er(v, s);
                    break;
                }
                case 13: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_er(v, s, v2);
                    break;
                }
                case 14: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_far(v, s);
                    break;
                }
                case 15: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_far_mem(v, s);
                    break;
                }
                case 16: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_invlpga(v, s);
                    break;
                }
                case 17: {
                    instrInfo = new SimpleInstrInfo_maskmovq(s);
                    break;
                }
                case 21: {
                    instrInfo = new SimpleInstrInfo_movabs(s);
                    break;
                }
                case 23: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_nop(v, s, v2);
                    break;
                }
                case 24: {
                    int v = reader.readByte();
                    ca[0] = 119;
                    String s2 = InstrInfos.addSuffix(s, ca);
                    ca[0] = 100;
                    String s3 = InstrInfos.addSuffix(s, ca);
                    ca[0] = 113;
                    String s4 = InstrInfos.addSuffix(s, ca);
                    instrInfo = new SimpleInstrInfo_OpSize(v, s, s2, s3, s4);
                    break;
                }
                case 25: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    String s4 = strings[reader.readCompressedUInt32()];
                    instrInfo = new SimpleInstrInfo_OpSize2_bnd(s, s2, s3, s4);
                    break;
                }
                case 26: {
                    ca[0] = (char)reader.readByte();
                    String s2 = InstrInfos.addSuffix(s, ca);
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_OpSize3(v, s, s2);
                    break;
                }
                case 27: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os(v, s);
                    break;
                }
                case 28: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os(v, s, v2);
                    break;
                }
                case 29: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    if (v2 > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_os_call(v, s, v2 != 0);
                    break;
                }
                case 31: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s});
                    break;
                }
                case 32: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s, s2});
                    break;
                }
                case 33: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_cc(v, new String[]{s, s2, s3});
                    break;
                }
                case 34: {
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v2, new String[]{s});
                    break;
                }
                case 35: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v2, new String[]{s, s2});
                    break;
                }
                case 36: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    int v2 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v2, new String[]{s, s2, s3});
                    break;
                }
                case 37: {
                    int v3 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v3, new String[]{s}, v2);
                    break;
                }
                case 38: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v3 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v3, new String[]{s, s2}, v2);
                    break;
                }
                case 39: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    String s3 = strings[reader.readCompressedUInt32()];
                    int v3 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_jcc(v, v3, new String[]{s, s2, s3}, v2);
                    break;
                }
                case 40: {
                    String s2 = strings[reader.readCompressedUInt32()];
                    int v3 = reader.readCompressedUInt32();
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_os_loop(v, v3, v2, new String[]{s, s2});
                    break;
                }
                case 41: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_os_loop(v, -1, v2, new String[]{s});
                    break;
                }
                case 42: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_mem(v, s);
                    break;
                }
                case 43: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_mem_reg16(v, s);
                    break;
                }
                case 44: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_os_mem2(v, s, v2);
                    break;
                }
                case 45: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_pblendvb(s, v);
                    break;
                }
                case 47: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_pclmulqdq(s, FormatterConstants.getPseudoOps(v));
                    break;
                }
                case 48: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_pops(s, FormatterConstants.getPseudoOps(v));
                    break;
                }
                case 50: {
                    instrInfo = new SimpleInstrInfo_Reg16(s);
                    break;
                }
                case 51: {
                    instrInfo = new SimpleInstrInfo_Reg32(s);
                    break;
                }
                case 52: {
                    instrInfo = new SimpleInstrInfo_reverse(s);
                    break;
                }
                case 22: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_sae(v, s);
                    break;
                }
                case 46: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_push_imm8(v, v2, s);
                    break;
                }
                case 30: {
                    int v = reader.readCompressedUInt32();
                    int v2 = reader.readByte();
                    instrInfo = new SimpleInstrInfo_push_imm(v, v2, s);
                    break;
                }
                case 18: {
                    int v = reader.readByte();
                    int v2 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_SignExt(v, s, v2);
                    break;
                }
                case 9: {
                    int v = reader.readByte();
                    int v2 = reader.readByte();
                    int v3 = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_SignExt(v, v2, s, v3);
                    break;
                }
                case 49: {
                    int v = reader.readByte();
                    instrInfo = new SimpleInstrInfo_imul(v, s);
                    break;
                }
                case 19: {
                    int v = reader.readByte();
                    if (v > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_STIG1(s, v != 0);
                    break;
                }
                case 20: {
                    int v = reader.readByte();
                    if (v > 1) {
                        throw new UnsupportedOperationException();
                    }
                    instrInfo = new SimpleInstrInfo_STIG2(s, v != 0);
                    break;
                }
                case 6: {
                    int v = reader.readCompressedUInt32();
                    instrInfo = new SimpleInstrInfo_STIG2(s, v);
                    break;
                }
                case 11: {
                    instrInfo = new SimpleInstrInfo_XLAT(s);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            infos[i] = instrInfo;
            if (currentIndex < 0) continue;
            reader.setIndex(currentIndex);
        }
        if (reader.canRead()) {
            throw new UnsupportedOperationException();
        }
        return infos;
    }
}

