/*
 * Decompiled with CFR 0.152.
 */
package com.github.icedland.iced.x86.fmt.intel;

import com.github.icedland.iced.x86.Instruction;
import com.github.icedland.iced.x86.fmt.FormatterOptions;
import com.github.icedland.iced.x86.fmt.intel.InstrInfo;
import com.github.icedland.iced.x86.fmt.intel.InstrOpInfo;
import com.github.icedland.iced.x86.internal.fmt.FormatterString;

final class SimpleInstrInfo_pops
extends InstrInfo {
    private final FormatterString mnemonic;
    private final FormatterString[] pseudo_ops;

    SimpleInstrInfo_pops(String mnemonic, FormatterString[] pseudo_ops) {
        this.mnemonic = new FormatterString(mnemonic);
        this.pseudo_ops = pseudo_ops;
    }

    @Override
    InstrOpInfo getOpInfo(FormatterOptions options, Instruction instruction) {
        InstrOpInfo info = new InstrOpInfo(this.mnemonic, instruction, 0);
        int imm = instruction.getImmediate8() & 0xFF;
        if (options.getUsePseudoOps() && Integer.compareUnsigned(imm, this.pseudo_ops.length) < 0) {
            info.mnemonic = this.pseudo_ops[imm];
            SimpleInstrInfo_pops.removeLastOp(info);
        }
        return info;
    }

    static void removeLastOp(InstrOpInfo info) {
        switch (info.opCount) {
            case 4: {
                info.op3Index = (byte)-1;
                break;
            }
            case 3: {
                info.op2Index = (byte)-1;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        info.opCount = (byte)(info.opCount - 1);
    }
}

